<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

define('BLOCK_RDG_TYPE_LATEST', 'latest');
define('BLOCK_RDG_TYPE_SPECIFIC', 'specific');
define('BLOCK_RDG_TYPE_EXTERNAL', 'external');

class Rdg_Blocks_Slider_Latest_Post extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SLIDER_LATEST_POST;
    private $block_folder_name = 'rdg-slider-latest-post';
    private $block_title = 'RDG Slider Latest Post';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'slider', 'latest', 'post'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
        add_action('acf/init', [$this, 'register_image_size'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_slider_latest_post.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_slider_latest_post_block_azsdw34c4v3232',
                'title' => 'Block_rdg_slider_latest_post',
                'fields' => array(
                    array(
                        'key' => 'field_63b32a34c446d',
                        'label' => 'Title',
                        'name' => 'title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b32a45c446e',
                        'label' => 'Heading',
                        'name' => 'heading',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'Heading H1',
                            'h2' => 'Heading H2',
                            'h3' => 'Heading H3',
                            'span' => 'Heading Span',
                        ),
                        'default_value' => 'h1',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63b32a8cc446f',
                        'label' => 'Padding',
                        'name' => 'padding',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 0,
                        'min' => 0,
                        'max' => 20,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b32aa9c4470',
                        'label' => 'Size',
                        'name' => 'size',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 3,
                        'min' => 1,
                        'max' => 20,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b32ac8c4471',
                        'label' => 'Size LG',
                        'name' => 'size_lg',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 0,
                        'min' => 0,
                        'max' => 20,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b32ae2c4472',
                        'label' => 'Size MD',
                        'name' => 'size_md',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 0,
                        'min' => 0,
                        'max' => 20,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b32af0c4473',
                        'label' => 'Size SM',
                        'name' => 'size_sm',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 0,
                        'min' => 0,
                        'max' => 20,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b32b10c4474',
                        'label' => 'Color',
                        'name' => 'title_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#3a96e0',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63b32b31c4475',
                        'label' => 'Color Shadow',
                        'name' => 'title_color_shadow',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b32a34c446d',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#03467d',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_63b321f93c4e5',
                        'label' => 'Show',
                        'name' => 'show',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest Posts',
                            'specific' => 'Specific Posts',
                            'external' => 'External Posts',
                        ),
                        'default_value' => 'latest',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63b322795a890',
                        'label' => 'Select Category Type',
                        'name' => 'select_category_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b321f93c4e5',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'include' => 'Include Category',
                            'exclude' => 'Exclude Category',
                        ),
                        'default_value' => 'include',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63b322d45a891',
                        'label' => 'Category Include',
                        'name' => 'category_include',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b322795a890',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'category',
                        'add_term' => 1,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_63b32379813a4',
                        'label' => 'Category Exclude',
                        'name' => 'category_exclude',
                        'aria-label' => '',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b322795a890',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'category',
                        'add_term' => 1,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'id',
                        'field_type' => 'multi_select',
                        'allow_null' => 1,
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_63b323bdb846b',
                        'label' => 'Quantity',
                        'name' => 'quantity',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b321f93c4e5',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 12,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63b3241b7327f',
                        'label' => 'Elements',
                        'name' => 'elements_post',
                        'aria-label' => '',
                        'type' => 'relationship',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b321f93c4e5',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'post_type' => array(
                            0 => 'post',
                        ),
                        'taxonomy' => '',
                        'filters' => array(
                            0 => 'search',
                            1 => 'taxonomy',
                        ),
                        'return_format' => 'object',
                        'min' => 1,
                        'max' => 12,
                        'elements' => array(
                            0 => 'featured_image',
                        ),
                    ),
                    array(
                        'key' => 'field_63b32532bf62d',
                        'label' => 'List External Post',
                        'name' => 'elements_external',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63b321f93c4e5',
                                    'operator' => '==',
                                    'value' => 'external',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63b32577bf62e',
                                'label' => 'Image',
                                'name' => 'image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63b321f93c4e5',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_63b32532bf62d',
                            ),
                            array(
                                'key' => 'field_63b325b2bf62f',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63b32532bf62d',
                            ),
                            array(
                                'key' => 'field_63b325c3bf630',
                                'label' => 'Content',
                                'name' => 'content',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => '',
                                'placeholder' => '',
                                'new_lines' => '',
                                'parent_repeater' => 'field_63b32532bf62d',
                            ),
                            array(
                                'key' => 'field_63b325d7bf631',
                                'label' => 'Link Post',
                                'name' => 'link_post',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63b32532bf62d',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-slider-latest-post',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function register_image_size() {
        add_image_size('slider-latest-post', 1400, 390, true);
    }

    public function get_title($fields) {
        $rdg_helpers = new Rdg_Blocks_Helpers();

        $style = $rdg_helpers->get_title_sizes($fields);
        $title = (!empty($fields['title'])) ? $fields['title'] : '';
        $heading = (!empty($fields['heading'])) ? $fields['heading'] : 'span';
        $title_color = (!empty($fields['title_color'])) ? $fields['title_color'] : '3a96e0';
        $title_color_shadow = (!empty($fields['title_color_shadow'])) ? $fields['title_color_shadow'] : '#03467d';
        $title_bottom = (!empty($fields['padding'])) ? $fields['padding'] : 0;

        $styles = [];
        $style[] = (!empty($title_color)) ? 'color: '.$title_color : 'color: #ffffff';

        if (!empty($title_bottom)) {
            $style[] = 'padding-bottom: '.$title_bottom.'rem';
        }

        if (!empty($title_color_shadow)) {
            $style[] = 'text-shadow: 0px 1px 1px '.$title_color_shadow;
        }
    
        if (count($style) > 0) {
            $styles = implode('; ', $style).';';
        }
    
        return [$heading, $title, $styles];
    }

    public function get_elements_type($fields) {
        $show = $fields['show'];

        if (BLOCK_RDG_TYPE_SPECIFIC == $show) {
            return $fields['elements_post'];
        }

        if (BLOCK_RDG_TYPE_EXTERNAL === $show) {
            return $fields['elements_external'];
        }

        $get_quantity = $fields['quantity'];
        $quantity = $get_quantity ? $get_quantity : 1;

        $category = '';
        $category_type = '';
        $select_category_type = $fields['select_category_type'];

        if (!empty($select_category_type)) {
            if ('include' == $select_category_type) {
                $category_type = 'category__in';
                $category = $fields['category_include'];
            } else {
                $category_type = 'category__not_in';
                $category = $fields['category_exclude'];
            }
        }

        $args = [
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => $quantity,
        ];

        if (!empty($category_type)) {
            $args[$category_type] = $category;
        }

        $elements = (new WP_Query($args))->posts;
        wp_reset_postdata();

        return $elements;
    }

    public function get_image($image_id) {
        $post_thumbnail_id = get_post_thumbnail_id($image_id);

        if (empty($post_thumbnail_id)) {
            return '';
        }

        $attachment = wp_get_attachment_image_src($post_thumbnail_id, 'slider-latest-post');
    
        return $attachment[0];
    }
}

$rdg_slider_latest_post_class = new Rdg_Blocks_Slider_Latest_Post();
$rdg_slider_latest_post_class->init();

return $rdg_slider_latest_post_class;
