<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-image-column'];
    $block_image_column = $rdgb->settings->get_block('rdg-image-column');

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    list($heading, $title, $styles) = $block_image_column->get_title(get_fields());
    $width_columns = (!empty(get_field('width_columns'))) ? get_field('width_columns') : null;
    $padding_column = (!empty(get_field('padding_column'))) ? get_field('padding_column') : 0;
    $display_columns = (!empty(get_field('display_columns'))) ? get_field('display_columns') : 'flex-row';
    $image = (!empty(get_field('image'))) ? get_field('image') : null;
    $links = get_field('links');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container">
            <?php if(!empty($title)): ?>
                <div class="wpcr-title" style="<?php echo $styles; ?>">
                    <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
                </div>
            <?php endif; ?>
                <?php 
                    $styles = $block_image_column->get_style('flex-direction', get_fields());
                    $classes = $block_image_column->get_style('flex-class', get_fields());
                    $width = $block_image_column->get_style('width', $width_columns['column']);
                ?>
            <div class="content <?php echo $classes;?>" style="<?php echo $width;?> --padding-column: <?php echo $padding_column.'rem';?>; --display-column: <?php echo $display_columns; ?>; <?php echo $styles; ?>">
                <?php if (!empty($image)): ?>
                    <div class="image">
                        <img src="<?php echo $image['url']; ?>" alt="">
                    </div>
                <?php endif; ?>
                <div class="blocks">
                    <InnerBlocks />
                </div>
            </div>

            <div class="buttons">
                <?php if (is_array($links) && count($links)): ?>
                    <?php foreach($links as $link): ?>
                        <?php
                            $link_class = '';
                            $link_style = '';
                            if ($link['default_styles'] != 'custom') {
                                $link_class = 'class="'.$link['default_styles'].'"';
                            } else {
                                $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.gameadvisers2022_simple_text_button_get_style('buttons', $link).'"';
                            }
                        ?>
                        <?php if (!empty($link['link']['url']) && !empty($link['link']['title'])): ?>
                            <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
