<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_NEW_PARAGRAPH_CUSTOM;
    $block_classes = [$block_name];
    $block_new_paragraph_custom = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $elements = get_field('elements');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if ($elements != false): ?>
                <div class="items">
                    <?php foreach($elements as $element): ?>
                        <div class="item">
                            <?php if (!empty($element['title'])): ?>
                                <?php list($heading, $title, $styles, $line) = $block_new_paragraph_custom->get_sub_title($element); ?>
                                <div class="title" style="<?php echo $styles; ?>">
                                    <<?php echo $heading; ?> style="<?php echo $line; ?>"><?php echo $title; ?></<?php echo $heading; ?>>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($element['sub_title'])): ?>
                                <div class="sub-title">
                                    <span><?php echo $element['sub_title']; ?></span>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($element['paragraph'])): ?>
                                <div class="description"><?php echo $element['paragraph']; ?></div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
