<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-faq'];
    $block_faq = $rdgb->settings->get_block(BLOCK_RDG_FAQ);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $id_faq = (!empty(get_field('faq_page_id'))) ? get_field('faq_page_id') : random_int(1, 999999);
    $faqs = get_field('faqs');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div id="items">
                <?php
                    $i = 1;
                    $max = (!empty($faqs)) ? count($faqs) : 0;
                ?>
                <?php if ($max > 0): ?>
                    <?php foreach($faqs as $faq): ?>
                        <div class="item">
                            <div class="faq-header header" data="<?php echo $max;?>" id="heading<?php echo $id_faq.$i;?>" data-toggle="collapse" data-target="#collapse<?php echo $id_faq.$i;?>" aria-expanded="false" aria-controls="collapse<?php echo $id_faq.$i;?>">
                                <li><span><?php echo $faq['title']; ?></span></li>
                                <div class="icon">
                                    <i class="fal fa-plus" id="heading<?php echo $id_faq.$i;?>-down"></i>
                                    <i class="fal fa-minus hide" id="heading<?php echo $id_faq.$i;?>-up"></i>
                                </div>
                            </div>
                            <div id="collapse<?php echo $id_faq.$i;?>" class="collapse" aria-labelledby="heading<?php echo $id_faq.$i;?>" data-parent="#items">
                                <div class="body">
                                    <?php echo $faq['content']; ?>
                                </div>
                            </div>
                        </div>
                        <?php $i++; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php
    if ($max > 0 && !empty(get_field('faq_page_id'))) {
        echo $block_faq->set_json_faqs($faqs, get_field('faq_page_id'));
    }
?>
