<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-slider-latest-post'];
    $block_slider_latest_post = $rdgb->settings->get_block(BLOCK_RDG_SLIDER_LATEST_POST);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $elements = $block_slider_latest_post->get_elements_type(get_fields());
    $show = get_field('show');
    $titles = get_field('titles');
    $size_imagen = (!empty(get_field('size_imagen'))) ? get_field('size_imagen') : 'default';
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="body">
            <?php if (count($elements) > 0): ?>
                <div class="items">
                    <?php foreach($elements as $element): ?>
                        <div class="item">
                            <?php
                                $image = '';
                                if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                    $image = $block_slider_latest_post->get_image($element->ID);
                                } else {
                                    if (isset($element['image']['url']) && !empty($element['image']['url'])) {
                                        $image = $element['image']['url'];
                                    }
                                }
                            ?>
                            <div class="image <?php echo $size_imagen; ?>" style="background-image: url(<?php echo $image; ?>);"></div>
                            <footer>
                                <div class="footer-title">
                                    <?php
                                        $link_url = '';
                                        $link_target = '_self';

                                        if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                            $link_url = get_permalink($element);
                                        } else {
                                            if (isset($element['link_post']['url']) && !empty($element['link_post']['url'])) {
                                                $link_url = $element['link_post']['url'];
                                            }

                                            if (isset($element['link_post']['target']) && !empty($element['link_post']['target'])) {
                                                $link_target = $element['link_post']['target'];
                                            }
                                        } 
                                    ?>
                                    <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                                        <?php echo (!empty($element->post_title)) ? $element->post_title : $element['title']; ?>
                                    </a>
                                </div>
                                <?php
                                    $excerpt = '';
                                    if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                        if (!empty($element->post_excerpt)) {
                                            $excerpt = $element->post_excerpt;
                                        }
                                    } else {
                                        if (isset($element['content']) && !empty($element['content'])) {
                                            $excerpt = $element['content'];
                                        }
                                    }
                                ?>
                                <?php if (!empty($excerpt)): ?>
                                    <div class="footer-description">
                                        <?php echo $excerpt; ?>
                                    </div>
                                <?php endif; ?>
                            </footer>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
