(function($) {
    $(document).on('change','#rdg-leader-board-category',function(e) {
        e.preventDefault();
        $(".rdg-blocks .rdg-leader-board .list-items .message").hide();

        let ajax_url = rdg_picks_vs_var.ajaxurl;
        let items = $('#rdg-leader-board-date-range option:selected').val();
        let cat_seleted = $('#rdg-leader-board-category option:selected').val();

        let menus = $('.table .table-menu .menu a');
        $('.table .table-menu .menu a').removeClass('active');
        $('.table .table-menu .menu a').addClass('unactive');

        $.each(menus, function(key, val) {      
            if ($(val).attr('data-category') == cat_seleted) {
                $(val).removeClass('unactive');
                $(val).addClass('active');
            }
        }, cat_seleted);

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_leader_board',
                items: items,
                id_sub_category: cat_seleted,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado) {
                $('.rdg-blocks .rdg-leader-board').find('.list-items').html(resultado);
                $('#wait').hide();
                setTimeout(function() {
                    $(".rdg-blocks .rdg-leader-board .list-items .message").fadeOut(1500);
                }, 4000);
            }
        });
    });

    $(document).on('click','.table .table-menu .menu a',function(e) {
        e.preventDefault();

        if ($(e.target).hasClass('active')) {
            return;
        }

        let menus = $('.table .table-menu .menu a');
        let menu_id = $(this).attr('id');

        $.each(menus, function(key, val) {      
            if (menu_id == $(val).attr("id")) {
                $(val).removeClass('unactive');
                $(val).addClass('active');
            } else {
                $(val).removeClass('active');
                $(val).addClass('unactive');
            }
        }, menu_id);

        $(".rdg-blocks .rdg-leader-board .list-items .message").hide();

        let ajax_url = rdg_picks_vs_var.ajaxurl;
        let items = $('#rdg-leader-board-date-range option:selected').val();
        let link_seleted = $(this).attr('data-category');
        let categories = $('#rdg-leader-board-category option');

        $('#rdg-leader-board-category option').attr("selected", false);
        $.each(categories, function(key, option) {
            if ($(option).val() == link_seleted) {
                $('#rdg-leader-board-category option[value="'+link_seleted+'"]').attr("selected", "selected");
            }
        }, link_seleted);

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_leader_board',
                items: items,
                id_sub_category: link_seleted,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado) {
                $('.rdg-blocks .rdg-leader-board').find('.list-items').html(resultado);
                $('#wait').hide();
                setTimeout(function() {
                    $(".rdg-blocks .rdg-leader-board .list-items .message").fadeOut(1500);
                }, 4000);
            }
        });
    });

    $(document).on('change','#rdg-leader-board-date-range',function(e) {
        e.preventDefault();
        $(".rdg-blocks .rdg-leader-board .list-items .message").hide();

        let ajax_url = rdg_picks_vs_var.ajaxurl;
        let items = $('#rdg-leader-board-date-range option:selected').val();
        let cat_seleted = $('#rdg-leader-board-category option:selected').val();

        $.ajax({
            url : ajax_url,
            type: 'post',
            data: {
                action : 'load_leader_board',
                items: items,
                id_sub_category: cat_seleted,
            },
            beforeSend: function() {
                $('#wait').show();
            },
            success: function(resultado) {
                $('.rdg-blocks .rdg-leader-board').find('.list-items').html(resultado);
                $('#wait').hide();
                setTimeout(function() {
                    $(".rdg-blocks .rdg-leader-board .list-items .message").fadeOut(1500);
                }, 4000);
            }
        });
    });
}) (jQuery);
