<?php
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-latest-post'];
    $block_latest_post = $rdgb->settings->get_block(BLOCK_RDG_LATEST_POST);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $elements = $block_latest_post->get_elements_type(get_fields());
    $show = get_field('show');
    $titles = get_field('titles');

    $style_separator = '';
    $show_separator = (!empty(get_field('separator_show'))) ? get_field('separator_show') : null;
    $color_separator = (!empty(get_field('separator_color'))) ? get_field('separator_color') : '#CCC';
    $width_separator = (!empty(get_field('separator_width'))) ? get_field('separator_width').'px' : '1px';
    $presentation = (!empty(get_field('presentation'))) ? get_field('presentation') : 'small';

    if (!empty($show_separator) && $show_separator == 'show') {
        $style_separator = '--color-separator-latest-post: '.$color_separator.'; --width-separator-latest-post: '.$width_separator.';'; 
    }
?>
<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <?php if (count($elements) > 0): ?>
            <div class="posts" style="<?php echo (!empty($show_separator)) ? $style_separator : ''; ?>">
                <?php $i = 1; ?>
                <?php foreach($elements as $element): ?>
                    <div class="item<?php echo (!empty($title) && $i == 1) ? ' first-item-line' : ''; ?><?php echo ($presentation == 'small') ? ' small' : ''; ?>">
                        <div class="content">
                            <div class="title">
                                <a href="<?php echo get_permalink($element); ?>">
                                    <?php echo (!empty($element->post_title)) ? $element->post_title : $element['title']; ?>
                                </a>
                            </div>

                            <?php if ((isset($element->post_excerpt) && !empty($element->post_excerpt)) || (is_array($element) && isset($element['content']) && !empty($element['content']))): ?>
                                <div class="description">
                                    <?php echo (!empty($element->post_excerpt)) ? $element->post_excerpt : $element['content']; ?>
                                </div>
                            <?php endif; ?>

                            <div class="published">
                                <span>
                                    <?php
                                        $posted = DateTime::createFromFormat('Y-m-d H:i:s', (!empty($element->post_date)) ? $element->post_date : $element['date'])->format('U');
                                        echo human_time_diff($posted, current_time('U')). " ago";
                                    ?>
                                </span>
                            </div>
                        </div>

                        <?php
                            $image = '';
                            if (in_array($show, [BLOCK_RDG_LATEST_TYPE_LATEST, BLOCK_RDG_LATEST_TYPE_SPECIFIC]) ) {
                                $image = $block_latest_post->get_image($element->ID);
                            } else {
                                if (isset($element['image']['url']) && !empty($element['image']['url'])) {
                                    $image = $element['image']['url'];
                                }
                            }
                        ?>
                        <div class="image" style="background-image: url(<?php echo $image; ?>);"></div>
                    </div>
                    <?php $i++; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
