<?php
    global $rdgb;
    $block_top_winners = $rdgb->settings->get_block('rdg-top-winners');

    $link = get_field('link');
    $tops = get_field('tops');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    list($heading, $title, $styles) = $block_top_winners->get_title(get_fields());
?>

<div class="rdg-blocks">
    <div class="rdg-top-winners" style="<?php echo $position_block; ?>">
        <div class="header">
            <?php if(!empty($title)): ?>
                <div class="title" style="<?php echo $styles; ?>">
                    <<?php echo $heading; ?>><?php echo $title; ?></<?php echo $heading; ?>>
                </div>
            <?php endif; ?>
            <div class="header-footer"></div>
        </div>

        <div class="body">
            <div class="legend">
                <div class="legend-logo"></div>
                <div class="legend-win">Win</div>
                <div class="legend-dra">Dra</div>
            </div>
            <div class="tops">
                <?php if (!empty($tops)): ?>
                    <?php foreach($tops as $top): ?>
                        <div class="top">
                            <div class="separator">
                                <div class="top-logo">
                                    <?php if(!empty($top['image']['url'])): ?>
                                        <div class="logo">
                                            <img src="<?php echo $top['image']['url']; ?>" alt="">
                                        </div>
                                    <?php endif; ?>
                                    <div class="name"><?php echo $top['name']; ?></div>
                                </div>
                                <div class="top-win"><?php echo $top['win']; ?></div>
                                <div class="top-dra"><?php echo $top['dra']; ?></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="footer">
            <?php if(!empty($link)): ?>
                <div class="wpcr-title">
                    <a href="<?php echo $link['url']; ?>" target="<?php echo $link['target']; ?>">
                        <?php echo $link['title']; ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>

    </div>
</div>
