<div class="items">
    <?php if (!empty($posts)): ?>
        <?php foreach($posts as $post): ?>
            <div class="item">
                <div class="header">
                    <div class="date">
                        <?php echo DateTime::createFromFormat('Y-m-d H:i:s', $post->post_date)->format('F j, Y'); ?>
                    </div>
                </div>
                <div class="image" style="background-image: url(<?php echo posts_ajax_get_image($post->ID); ?>);"></div>
                <footer>
                    <div class="footer-title">
                        <?php echo (!empty($post->post_title)) ? $post->post_title : ''; ?>
                    </div>
                    <?php
                    //TODO: limitar cantidad de caracteres y ver si se toma de exerpt o de content
                        if (!empty($post->post_excerpt)) {
                            $excerpt = $post->post_excerpt;
                        } else {
                            $excerpt = $post->post_content;
                        }
                    ?>
                    <?php if (!empty($excerpt)): ?>
                        <div class="footer-description">
                            <?php echo wp_trim_words($excerpt, 35, false); ?>
                        </div>
                    <?php endif; ?>

                    <?php
                        $link_url = '';
                        $link_target = '_self';
                        $link_name = 'Read more';
                        $link_url = get_permalink($post);
                    ?>
                    <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                        <?php echo $link_name; ?>
                    </a>
                </footer>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>