<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_POSTS_AJAX;
    $block_classes = [$block_name];
    $block_posts_ajax = $rdgb->settings->get_block($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $items = (!empty(get_field('quantity'))) ? intval(get_field('quantity')) : 9;
    $sport_selected = get_field('sport');
    $league_selected = get_field('league');
    $sports = posts_ajax_get_sports('sport');
    $leagues = posts_ajax_get_sports('league', $sport_selected);

    $data = posts_ajax_get_elements([
        'quantity' => $items,
        'category_sport' => $sport_selected,
        'category_league' => $league_selected,
    ], $paged);

    $num_pages = intval($data->found_posts / $items);
    $posts = $data->posts;

    if (($data->found_posts % $items) != 0) {
        $num_pages++;
    }

    $titles = get_field('titles');

    $posts_titles = $block_posts_ajax->get_posts_ajax_titles(true);
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div <?php echo (!empty($block_id)) ? 'id="'.$block_id.'"' : ''; ?> class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div id="wait"></div>
            <div class="filter">
                <div class="categories">
                    <div class="select">
                        <?php if(is_array($sports) && count($sports) > 0): ?>
                            <select id="rdg-posts-ajax-sports" data-items="<?php echo $items; ?>" data-block-id="<?php echo $block_id; ?>">
                                <option value="0">By Sport</option>
                                <?php foreach ($sports as $sport): ?>
                                    <?php $select = ''; ?>
                                        <?php if ($sport->term_id == $sport_selected): ?>
                                            <?php $select = 'selected'; ?>
                                        <?php endif; ?>

                                    <option value="<?php echo $sport->term_id; ?>" <?php echo $select; ?>><?php echo $sport->name; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php endif; ?>
                    </div>

                    <div class="select">
                        <?php if(is_array($sports) && count($sports) > 0): ?>
                            <select id="rdg-posts-ajax-leagues" data-items="<?php echo $items; ?>" data-block-id="<?php echo $block_id; ?>">
                            <option value="0">By League</option>
                                <?php foreach ($leagues as $league): ?>
                                    <?php $select = ''; ?>
                                        <?php if ($league->term_id == $league_selected): ?>
                                            <?php $select = 'selected'; ?>
                                        <?php endif; ?>

                                    <option value="<?php echo $league->term_id; ?>" <?php echo $select; ?>><?php echo $league->name; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="posts">
                <?php if (is_array($posts) && count($posts) > 0): ?>
                    <?php require 'partials/posts.php'; ?>
                <?php endif; ?>
                <div class="posts-ajax-pagination" <?php echo (!empty($block_id)) ? 'data-block_id="'.$block_id.'"' : ''; ?>>
                    <?php echo posts_ajax_pagination($paged, $num_pages); ?>
                </div>
            </div>
        </div>
    </div>
</div>
