<?php
    global $rdgb;
    $block_styles = [];
    $block_classes = ['rdg-next-game'];
    $block_name = BLOCK_RDG_NEXT_GAME;
    $block_next_game = $rdgb->settings->get_block(BLOCK_RDG_NEXT_GAME);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $links = get_field('links');
    $home_team = (!empty(get_field('home_team'))) ? get_field('home_team') : [];
    $visitor_team = (!empty(get_field('visitor_team'))) ? get_field('visitor_team') : [];

    $date = (!empty(get_field('date'))) ? get_field('date') : '';
    $hour = (!empty(get_field('hour'))) ? get_field('hour') : '';
    $channel = (!empty(get_field('channel'))) ? get_field('channel') : '';
    $cin = (!empty(get_field('cin'))) ? get_field('cin') : '';

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <?php if (is_array($home_team) && count($home_team) > 0 && is_array($visitor_team) && count($visitor_team) > 0): ?>
            <div class="teams">
                <div class="home-team">
                    <div class="home-group">
                        <div class="home-details">
                            <span class="details-city"><?php echo $home_team['city']; ?></span>
                            <span class="details-name"><?php echo $home_team['name']; ?></span>
                            <span class="details-score"><?php echo $home_team['score']; ?></span>
                        </div>
                        <div class="home-logo">
                            <?php if (isset($home_team['logo']) && $home_team['logo'] != false): ?>
                                <img src="<?php echo $home_team['logo']; ?>" alt="Home Team Image">
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if (isset($home_team['ml']) && $home_team['ml'] != ''): ?>
                        <div class="home-stat">
                            <div class="stat-details"></div>
                            <div class="stat-logo">
                                <span>ML: </span>
                                <span class="<?php echo $home_team['ml_color']; ?>"><?php echo $home_team['ml']; ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="date-hour">
                    <div class="date">
                        <?php echo $date; ?>
                    </div>
                    <div class="hour">
                        <?php echo $hour; ?>
                    </div>
                    <div class="channel">
                        <?php echo $channel; ?>
                    </div>
                </div>
                <div class="visitor-team">
                    <div class="visitor-group">
                        <div class="visitor-logo">
                        <?php if (isset($visitor_team['logo']) && $visitor_team['logo'] != false): ?>
                            <img src="<?php echo $visitor_team['logo']; ?>" alt="Visitor Team Image">
                        <?php endif; ?>
                        </div>
                        <div class="visitor-details">
                            <span class="details-city"><?php echo $visitor_team['city']; ?></span>
                            <span class="details-name"><?php echo $visitor_team['name']; ?></span>
                            <span class="details-score"><?php echo $visitor_team['score']; ?></span>
                        </div>
                    </div>
    
                    <?php if (isset($visitor_team['ml']) && $visitor_team['ml'] != ''): ?>
                        <div class="visitor-stat">
                            <div class="stat-logo">
                                <span>ML:</span>
                                <span class="<?php echo $visitor_team['ml_color']; ?>"><?php echo $visitor_team['ml']; ?></span>
                            </div>
                            <div class="stat-details"></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="teams-date">
                <div class="date-hour">
                    <div class="date">
                        <?php echo $date; ?>
                    </div>
                    <div class="hour">
                        <?php echo $hour; ?>
                    </div>
                    <div class="channel">
                        <?php echo $channel; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if (!empty($cin)): ?>
            <div class="cin">
                <span>CIN</span>
                <span><?php echo $cin; ?></span>
            </div>
        <?php endif; ?>

        <?php if (is_array($links) && count($links) > 0): ?>
            <div class="buttons">
                <?php foreach($links as $link): ?>
                    <?php
                        $link_class = '';
                        $link_style = '';
                        if ($link['default_styles'] != 'custom') {
                            $link_class = 'class="'.$link['default_styles'].'"';
                        } else {
                            $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_next_game->get_style('buttons', $link).'"';
                        }
                    ?>
                    <?php if (!empty($link['link']['url']) && $link['link']['title']): ?>
                        <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
