<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

class Rdg_Blocks_Title
{
    private $block_name = 'rdg-title';
    private $block_folder_name = 'rdg-title';
    private $block_title = 'RDG Title';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'title'];
    private $block_mode = 'preview';
    private $block_category = "rdg-blocks";

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    public function get_block_name() {
        return $this->block_name;
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_title.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_title_block_hasd23ed12d',
                'title' => 'Block_rdg_title',
                'fields' => array(
                    array(
                        'key' => 'field_637395c92c537',
                        'label' => 'Title',
                        'name' => 'title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_637395dc2c538',
                        'label' => 'Heading',
                        'name' => 'heading',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_637395c92c537',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'h1' => 'Heading H1',
                            'h2' => 'Heading H2',
                            'h3' => 'Heading H3',
                            'span' => 'Heading Span',
                        ),
                        'default_value' => 'h1',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_637396662c53a',
                        'label' => 'Align',
                        'name' => 'title_align',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_637395c92c537',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'left' => 'Left',
                            'center' => 'Center',
                            'right' => 'Right',
                        ),
                        'default_value' => 'left',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_637396b02c53b',
                        'label' => 'Color',
                        'name' => 'title_color',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_637395c92c537',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#3a96e0',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_637396e62c53c',
                        'label' => 'Color Shadow',
                        'name' => 'title_color_shadow',
                        'aria-label' => '',
                        'type' => 'color_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_637395c92c537',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '#03467d',
                        'enable_opacity' => 0,
                        'return_format' => 'string',
                    ),
                    array(
                        'key' => 'field_637397112c53d',
                        'label' => 'Sizes',
                        'name' => 'sizes',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_637395c92c537',
                                    'operator' => '!=empty',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6373973e2c53e',
                                'label' => 'Size',
                                'name' => 'size',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_637395c92c537',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 3,
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_637397a82c53f',
                                'label' => 'Size LG',
                                'name' => 'size_lg',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_637395c92c537',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_637397c32c540',
                                'label' => 'Size MD',
                                'name' => 'size_md',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_637395c92c537',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_637397d62c541',
                                'label' => 'Size SM',
                                'name' => 'size_sm',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_637395c92c537',
                                            'operator' => '!=empty',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 20,
                                'placeholder' => '',
                                'step' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-title',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_title($fields) {
        $title = (!empty($fields['title'])) ? $fields['title'] : '';
        $heading = (!empty($fields['heading'])) ? $fields['heading'] : 'span';
        $padding = (!empty($fields['padding'])) ? $fields['padding'] : 0;
        $title_align = (!empty($fields['title_align'])) ? $fields['title_align'] : 'left';
        $title_color = (!empty($fields['title_color'])) ? $fields['title_color'] : '3a96e0';
        $title_color_shadow = (!empty($fields['title_color_shadow'])) ? $fields['title_color_shadow'] : '#03467d';
    
        $rdg_helpers = new Rdg_Blocks_Helpers();
        $style = $rdg_helpers->get_title_sizes(isset($fields['sizes']) ? $fields['sizes'] : []);
        $styles = [];
    
        $style[] = (!empty($title_align)) ? '--title-align: '.$title_align : '--title-align: left';
        $style[] = (!empty($padding)) ? 'padding-bottom: '.$padding.'rem' : 'padding-bottom: 0rem';
        $style[] = (!empty($title_color)) ? 'color: '.$title_color : 'color: #ffffff';
        $style[] = (!empty($title_color_shadow)) ? 'text-shadow: 0px 1px 1px '.$title_color_shadow : 'text-shadow: none';
    
        if (count($style) > 0) {
            $styles = implode('; ', $style).';';
        }
    
        return [$heading, $title, $styles];
    }
}

$rdg_title_class = new Rdg_Blocks_Title();
$rdg_title_class->init();

return $rdg_title_class;
