<?php 
    global $rdgb;
    $block_styles = [];
    $name_block = BLOCK_RDG_BEST_PPH;
    $block_classes = [$name_block];
    $block_best_pph = $rdgb->settings->get_block($name_block);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $elements = (!empty(get_field('elements'))) ? get_field('elements') : null;
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (is_array($elements) && count($elements) > 0): ?>
                <div class="items">
                    <?php foreach($elements as $element): ?>
                        <?php
                            $element_background = (!empty($element['background_color'])) ? $element['background_color'] : '#ffffff';
                            $element_header_logo = (isset($element['header']['logo']['url']) && !empty($element['header']['logo']['url'])) ? $element['header']['logo']['url'] : null;
                            $element_header_bg = (!empty($element['header']['background_color'])) ? $element['header']['background_color'] : '#000000';
                            
                            $element_features_list_style = (isset($element['features']['list_style']) && !empty($element['features']['list_style'])) ? $element['features']['list_style'] : 'check';
                            $element_features_list_color = (isset($element['features']['list_color']) && !empty($element['features']['list_color'])) ? $element['features']['list_color'] : '#000000';
                            $element_features_lists = (isset($element['features']['lists']) && !empty($element['features']['lists'])) ? $element['features']['lists'] : null;

                            $element_site_bg = (isset($element['site']['background_color']) && !empty($element['site']['background_color'])) ? $element['site']['background_color'] : '#ffffff';
                            $element_site_url = (isset($element['site']['url']) && !empty($element['site']['url'])) ? $element['site']['url'] : null;
                            $element_site_more = (isset($element['site']['more']) && !empty($element['site']['more'])) ? $element['site']['more'] : null;
                            
                            $element_description = (!empty($element['description'])) ? $element['description'] : null;
                            $element_buttons = (!empty($element['buttons'])) ? $element['buttons'] : null;
                        ?>

                        <div class="item" style="--element-color:<?php echo $element_background; ?>;">
                            <div class="header" style="--header-color:<?php echo $element_header_bg; ?>;">
                                <?php if (!empty($element_header_logo)): ?>
                                    <div class="logo">
                                        <img src="<?php echo $element_header_logo; ?>" alt="Image">
                                    </div>
                                <?php endif; ?>
                            </div>

                            <?php if (is_array($element_features_lists) && count($element_features_lists) > 0): ?>
                                <div class="features">
                                    <ul>
                                        <div class="center">
                                        <?php foreach($element_features_lists as $list): ?>
                                            <li>
                                                <span class="icon" style="--list-color:<?php echo $element_features_list_color; ?>;">
                                                    <?php echo file_get_contents(RDGBLOCKS_PLUGIN_URL.'dist/images/'.$element_features_list_style.'.svg'); ?>
                                                </span>
                                                <span class="value"><?php echo $list['list']; ?></span>
                                            </li>
                                        <?php endforeach; ?>
                                        </div>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($element_site_url) || !empty($element_site_more)): ?>
                                <div class="site" style="--site-color:<?php echo $element_site_bg; ?>;">
                                    <h4><?php echo $element_site_url; ?></h4>
                                    <span><?php echo $element_site_more; ?></span>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($element_description)): ?>
                                <div class="description"><p><?php echo $element_description; ?></p></div>
                            <?php endif; ?>

                            <?php if (is_array($element_buttons) && count($element_buttons) > 0): ?>
                                <div class="buttons">
                                    <?php foreach($element_buttons as $button): ?>
                                        <?php if (is_array($button['link']) && $button['link']['url'] != ''): ?>
                                            <a href="<?php echo $button['link']['url']; ?>" target="<?php echo (!empty($button['link']['target'])) ? $button['link']['target'] : '_self'; ?>">
                                        <?php endif; ?>

                                        <?php if ($button['type'] == 'image'): ?>
                                            <div class="item-button image-type">
                                                <?php
                                                    $button_bg = (!empty($button['background_color'])) ? $button['background_color'] : 'none';
                                                    $button_padding = (!empty($button['padding'])) ? $button['padding'].'rem' : '0';
                                                ?>
                                                <div class="body <?php echo (!is_array($button['texts']) || count($button['texts']) == 0) ? 'center' : ''; ?>" style="--body-bg: <?php echo $button_bg; ?>; --body-padding: <?php echo $button_padding; ?>;">
                                                    <?php if (!empty($button['image']['url'])): ?>
                                                        <div class="image">
                                                            <img src="<?php echo $button['image']['url']; ?>" alt="Image">
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if (is_array($button['texts']) && count($button['texts']) > 0): ?>
                                                        <div class="texts" style="<?php echo (!empty($button['image']['url'])) ? '--texts-with: calc(100% - 4rem);' : '--texts-with: calc(100%);'; ?>">
                                                            <?php foreach($button['texts'] as $text): ?>
                                                                <?php if (!empty($text['text'])): ?>
                                                                    <?php
                                                                        $title = $text['text'];
                                                                        $size = (!empty($text['size'])) ? $text['size'].'rem;' : '2rem;';
                                                                        $weight = (!empty($text['weight'])) ? $text['weight'].';' : '500;';
                                                                        $color = (!empty($text['color'])) ? $text['color'].';' : '#FFFFFF;';
                                                                        $text_padding = (!empty($text['text_padding'])) ? $text['text_padding'].'rem;' : '0;';
                                                                    ?>
                                                                    <span style="--text-size:<?php echo $size; ?> --text-padding:<?php echo $text_padding; ?> --text-weight:<?php echo $weight; ?> --text-color:<?php echo $color; ?>"><?php echo $title; ?></span>
                                                                <?php endif; ?>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <?php if (!empty($button['text_basic'])): ?>
                                                <?php
                                                    $padding = (!empty($button['padding'])) ? $button['padding'].'rem;' : '.5rem;';
                                                    $title = (!empty($button['text_basic'])) ? $button['text_basic'] : 'Link To';
                                                    $size = (!empty($button['size_basic'])) ? $button['size_basic'].'rem;' : '2rem;';
                                                    $weight = (!empty($button['weight_basic'])) ? $button['weight_basic'].';' : '500;';
                                                    $color = (!empty($button['color_basic'])) ? $button['color_basic'].';' : '#FFFFFF;';

                                                    $style = '';
                                                    if ($button['style'] == 'custom') {
                                                        $border_color = (!empty($button['border_color'])) ? $button['border_color'].';' : '#3a96e0;';
                                                        $background_color = (!empty($button['background_color_button'])) ? $button['background_color_button'].';' : '#0160ac;';
                                                        $hover_color = (!empty($button['hover_color'])) ? $button['hover_color'].';' : '#03467d;';
                                                    } else {
                                                        $style = $button['style'];
                                                        $border_color = '';
                                                        $background_color = '';
                                                        $hover_color = '';
                                                    }

                                                ?>

                                                <?php if ($button['style'] == 'custom'): ?>
                                                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?> --button-bg:<?php echo $background_color; ?> --button-hover:<?php echo $hover_color; ?>  --button-border:<?php echo $border_color; ?>">
                                                        <span><?php echo $title; ?></span>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?>">
                                                        <span><?php echo $title; ?></span>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if (is_array($button['link']) && $button['link']['url'] != ''): ?>
                                            </a>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>

                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="message">
                    <span><?php echo __('Must add some item.'); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
