<?php

function create_post_type_review()
{
    $supports = array(
        'title', // post title
        'editor', // post content
        'author', // post author
        'thumbnail', // featured images
        'excerpt', // post excerpt
        'custom-fields', // custom fields
        'comments', // post comments
    );

    $labels = array(
        'name' => _x('Reviews', 'plural'),
        'singular_name' => _x('Review', 'singular'),
        'menu_name' => _x('Reviews', 'admin menu'),
        'name_admin_bar' => _x('Reviews', 'admin bar'),
        'add_new' => _x('Add New', 'add new'),
        'add_new_item' => __('Add New Review'),
        'new_item' => __('New Review'),
        'edit_item' => __('Edit Review'),
        'view_item' => __('View Reviews'),
        'all_items' => __('All Reviews'),
        'search_items' => __('Search Reviews'),
        'not_found' => __('No Review found.'),
    );

    $args = array(
        'supports' => $supports,
        'labels' => $labels,
        'public' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'review'),
        'has_archive' => true,
        'hierarchical' => false,
        'show_in_rest' => true,
    );

    register_post_type('review', $args);
}

add_action('init', 'create_post_type_review');
