<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Picks_Vs extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_PICKS_VS;
    private $block_folder_name = 'rdg-picks-vs';
    private $block_title = 'RDG Picks Vs';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'sports', 'picks'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $config_page_title = 'RDG Picks Vs';
    protected $config_menu_title = 'Picks Vs';
    protected $config_menu_order = 3;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_picks_vs.css'),
                'enqueue_assets' => function(){
                    wp_register_script('rdg_picks_vs_script', RDGBLOCKS_PLUGIN_URL.'blocks/rdg-picks-vs/assets/js/rdg-picks-vs.js', array('jquery'), '1', true);
                    wp_enqueue_script('rdg_picks_vs_script');
                    wp_localize_script('rdg_picks_vs_script','rdg_picks_vs_var',['ajaxurl' => admin_url('admin-ajax.php')]);
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_picks_vs_block_sdf4334r',
                'title' => 'Block_rdg_picks_vs',
                'fields' => array(
                    array(
                        'key' => 'field_645f355f3345d',
                        'label' => 'Show In',
                        'name' => 'show_in',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'full' => 'Full width',
                            'content' => 'Content width',
                        ),
                        'default_value' => 'full',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_642addasdadad',
                        'label' => 'Custom Link',
                        'name' => 'custom_link_show',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hide' => 'Hide',
                            'show' => 'Show',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_642adsasd',
                        'label' => 'Link',
                        'name' => 'custom_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_642addasdadad',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'field_63d9b54a73136',
                        'label' => 'Source',
                        'name' => 'source',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'manual' => 'Manual',
                            'api' => 'API',
                        ),
                        'default_value' => 'manual',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'save_other_choice' => 0,
                        'layout' => 'horizontal',
                    ),
                    array(
                        'key' => 'field_63cc527c9d04e',
                        'label' => 'Picks',
                        'name' => 'picks',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63cc527cbe269',
                                'label' => 'Category',
                                'name' => 'category',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cc527c9d04e',
                            ),
                            array(
                                'key' => 'field_63cc527cc1bba',
                                'label' => 'Time',
                                'name' => 'time',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cc527c9d04e',
                            ),
                            array(
                                'key' => 'field_63cc527cc584e',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cc527c9d04e',
                            ),
                            array(
                                'key' => 'field_63cc527cc92a2',
                                'label' => 'Vs',
                                'name' => 'vs',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63cc527c9d04e',
                            ),
                            array(
                                'key' => 'field_63cc527cccd29',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 2,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63cc527ce34ba',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_63cc527cccd29',
                                    ),
                                    array(
                                        'key' => 'field_63cc527ce6f33',
                                        'label' => 'Name',
                                        'name' => 'name',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63cc527cccd29',
                                    ),
                                ),
                                'parent_repeater' => 'field_63cc527c9d04e',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_63dbbd1ec1393',
                        'label' => 'Filter Category',
                        'name' => 'filter_category',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hide' => 'Hide',
                            'show' => 'Show',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63d9b5edd9ce1',
                        'label' => 'Category',
                        'name' => 'category',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => $this->get_picks_vs_titles(true),
                        'default_value' => 'NFL',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63d9b735d9ce3',
                        'label' => 'Number of Items',
                        'name' => 'number_of_items',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 3,
                        'min' => 0,
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63dbbff733345',
                        'label' => 'Filter Date',
                        'name' => 'filter_date',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63d9b54a73136',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hide' => 'Hide',
                            'show' => 'Show',
                        ),
                        'default_value' => 'hide',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63e6b06bc7010',
                        'label' => 'Date Type',
                        'name' => 'date_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63dbbff733345',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'yesterday' => 'Yesterday',
                            'now' => 'Now',
                            'tomorrow' => 'Tomorrow',
                            'range' => 'Range',
                        ),
                        'default_value' => 'now',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_63e6af4c50608',
                        'label' => 'Since Date',
                        'name' => 'since_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63e6b06bc7010',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_63e6afb550609',
                        'label' => 'To Date',
                        'name' => 'to_date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63e6b06bc7010',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'Y-m-d',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_63dbbed44c4bd',
                        'label' => 'Date Range',
                        'name' => 'date_range',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_63dbbff733345',
                                    'operator' => '==',
                                    'value' => 'show',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63eb9ff68a727',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'link-info' => 'Active',
                                    'link-default' => 'Deactive',
                                ),
                                'default_value' => 'link-default',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63eb8ed62d5eb',
                                'label' => 'Date Type',
                                'name' => 'date_type',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63dbbff733345',
                                            'operator' => '==',
                                            'value' => 'show',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yesterday' => 'Yesterday',
                                    'now' => 'Now',
                                    'tomorrow' => 'Tomorrow',
                                    'range' => 'Range',
                                ),
                                'default_value' => 'now',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63eb8ee12d5ec',
                                'label' => 'Since Date',
                                'name' => 'since_date',
                                'aria-label' => '',
                                'type' => 'date_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63eb8ed62d5eb',
                                            'operator' => '==',
                                            'value' => 'range',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'display_format' => 'Y-m-d',
                                'return_format' => 'Y-m-d',
                                'first_day' => 1,
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63eb8eef2d5ed',
                                'label' => 'To Date',
                                'name' => 'to_date',
                                'aria-label' => '',
                                'type' => 'date_picker',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_63eb8ed62d5eb',
                                            'operator' => '==',
                                            'value' => 'range',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'display_format' => 'Y-m-d',
                                'return_format' => 'Y-m-d',
                                'first_day' => 1,
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63e6b171f782c',
                                'label' => 'Title Date',
                                'name' => 'title_date',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                            array(
                                'key' => 'field_63dbbde453392',
                                'label' => 'Icon',
                                'name' => 'icon',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'fa-circle' => 'Circle',
                                    'fa-chevron-circle-up' => 'Circle Up',
                                    'fa-chevron-circle-right' => 'Circle Right',
                                    'fa-chevron-circle-down' => 'Circle Down',
                                    'fa-chevron-circle-left' => 'Circle Left',
                                    'fa-dot-circle' => 'Circle Dot',
                                    'fa-check-circle' => 'Circle Check',
                                    'fa-times-circle' => 'Circle X Mark',
                                    'fa-user-circle' => 'Circle User',
                                    'fa-question-circle' => 'Circle Question',
                                    'fa-info-circle' => 'Circle Info',
                                ),
                                'default_value' => false,
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 1,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                                'parent_repeater' => 'field_63dbbed44c4bd',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_picks_vs_block_sdfw34fs2332',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'field_63d9b987bd0be',
                        'label' => 'URL',
                        'name' => 'picks_vs_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '70',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63d9b987c0adf',
                        'label' => 'Cache Refresh Frequency (Hours)',
                        'name' => 'picks_vs_interval',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => '',
                        'max' => '',
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63d9b987c4506',
                        'label' => 'Token',
                        'name' => 'picks_vs_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_63d9b987cbb5b',
                        'label' => 'Picks Vs Titles',
                        'name' => 'picks_vs_titles',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d9b987daa29',
                                'label' => 'Title Slug',
                                'name' => 'picks_vs_title_slug',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d9b987cbb5b',
                            ),
                            array(
                                'key' => 'field_63d9b987de617',
                                'label' => 'Title Value',
                                'name' => 'picks_vs_title_value',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d9b987cbb5b',
                            ),
                            array(
                                'key' => 'field_63e6fae32fedc',
                                'label' => 'Sub Titles',
                                'name' => 'sub_titles',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63e6fb2e2fedd',
                                        'label' => 'Sub Title Slug',
                                        'name' => 'sub_title_slug',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63e6fae32fedc',
                                    ),
                                    array(
                                        'key' => 'field_63e6fb3d2fede',
                                        'label' => 'Sub Title Value',
                                        'name' => 'sub_title_value',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63e6fae32fedc',
                                    ),
                                ),
                                'parent_repeater' => 'field_63d9b987cbb5b',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_picks_vs_titles($is_sub_title = false) {
        $sport_titles = [];
        $titles = get_field('picks_vs_titles', 'option');

        if (is_array($titles) && count($titles) > 0) {
            foreach ($titles as $title) {
                if (is_array($title['sub_titles']) && count($title['sub_titles']) > 0 && $is_sub_title) {
                    $sub_titles = [];
                    foreach ($title['sub_titles'] as $sub_title) {
                        $sub_titles[$title['picks_vs_title_slug'].'-'.$sub_title['sub_title_slug']] = $sub_title['sub_title_value'];
                    }
                } else {
                    $sub_titles = $title['picks_vs_title_value'];
                }

                $sport_titles[$title['picks_vs_title_slug']] = $sub_titles;
            }
        }

        return $sport_titles;
    }

    public function get_api_attributes($items = null, $attributes = []) {
        $api_url = get_field('picks_vs_api_url', 'option');
        $api_token = get_field('picks_vs_api_token', 'option');
        $cache_refresh = get_field('picks_vs_interval', 'option');
        $items = (!empty($items)) ? intval($items) : 10;

        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;

        if (isset($attributes['category']) && strpos($attributes['category'], '-')) {
            list($category_primary, $sub_category) = explode('-', $attributes['category']);
        } else {
            $sub_category = 'NULL';

            if (isset($attributes['category']) && !empty($attributes['category'])) {
                $category_primary = $attributes['category'];
            } else {
                $category_primary = 'NFL';
            }
        }

        $api_url .= '/'.$category_primary;
        $api_url .= '/'.$sub_category;

        $api_url .= '/'.$items;

        if (isset($attributes['date']) && !empty($attributes['date'])) {
            $api_url .= '/'.$attributes['date'];
        } else {
            $api_url .= '/NULL/NULL';
        }

        $api_request = $api_url.'?api_token='.$api_token;

        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
        ];
    }

    public function get_resources($request, $cache_file) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';

        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $picks_vs = $rdgb_helpers->get_api_data($this->block_name, $cache_file, $request);

        if (!empty($picks_vs->message)) {
            $data->message = $picks_vs->message;
        
            return $data;
        }

        $data->json = $picks_vs->json;

        return $data;
    }

    public function get_resources_ajax($request) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';

        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $picks_vs = $rdgb_helpers->get_api_data_ajax($this->block_name, $request);

        if (!empty($picks_vs->message)) {
            $data->message = $picks_vs->message;
        
            return $data;
        }

        $data->json = $picks_vs->json;

        return $data;
    }

    public function get_style($type, $fields) {
        $style = [];

        if ('buttons' == $type) {
            $style[] = 'background-color: '.$fields['background_color'];
            $style[] = 'color: '.$fields['text_color'];
    
            return implode('; ', $style);
        }
    
        return '';
    }

    public function get_width($type, $filter_category, $filter_date) {
        if ($type == 'style') {
            if ($filter_category == 'hide' && $filter_date == 'hide') {
                return '';
            }
    
            if ($filter_category == 'show' && $filter_date == 'show') {
                $style[] = '--category-align: flex-end';
                $style[] = '--category-select-width: 70%';
                $style[] = '--sub-category-align: flex-start';
        
                return implode('; ', $style).';';
            }
    
            if ($filter_category == 'show' && $filter_date == 'hide') {
                $style[] = '--category-align: center';
                $style[] = '--category-select-width: 40%';
                $style[] = '--sub-category-align: flex-start';
        
                return implode('; ', $style).';';
            }
        
            $style[] = '--category-align: flex-end';
            $style[] = '--sub-category-align: center';
    
            return implode('; ', $style).';';
        }

        if ($filter_category == 'hide' && $filter_date == 'hide') {
            return '';
        }

        if ($filter_category == 'show' && $filter_date == 'show') {
            return 'w-50';
        }
        
        if ($type == 'class_category') {
            if ($filter_category == 'show' && $filter_date == 'hide') {
                return 'w-100';
            }
        }

        if ($type == 'class_sub_category') {
            if ($filter_category == 'hide' && $filter_date == 'show') {
                return 'w-100';
            }
        }
        
        return '';
    }

    public function get_date_filter($date_type, $since_date, $to_date) {
        if ($date_type == API_DATE_TYPE_YESTERDAY) {
            return date('Y-m-d', strtotime("-1 days")).'/NULL';
        }

        if ($date_type == API_DATE_TYPE_NOW) {

            return 'NULL/NULL';
        }
        
        if ($date_type == API_DATE_TYPE_TOMORROW) {

            return date('Y-m-d',strtotime("+1 days")).'/NULL';
        }

        if ($date_type == API_DATE_TYPE_RANGE) {
            if (!empty($since_date) && !empty($to_date)) {
                return $since_date.'/'.$to_date;
            }

            if (empty($since_date) && empty($to_date)) {
                return 'NULL/NULL';
            }

            if (!empty($since_date) && empty($to_date)) {
                return $since_date.'/NULL';
            }

            if (empty($since_date) && !empty($to_date)) {
                return 'NULL/'.$to_date;
            }
        }

        return 'NULL/NULL';
    }

    public function get_image($url_image) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $url_image = $rdgb_helpers->get_image_source($url_image);

        return $url_image;
    }
}

add_action('wp_ajax_nopriv_load_picks_vs','get_picks_vs_data');
add_action('wp_ajax_load_picks_vs','get_picks_vs_data');

function get_picks_vs_data() {
    global $rdgb;
    $block_name = BLOCK_RDG_PICKS_VS;
    $block_picks_vs = $rdgb->settings->get_block($block_name);

    $message = null;
    $items = $_POST['items'];
    $id_sub_category = isset($_POST['id_sub_category']) ? $_POST['id_sub_category'] : null;
    $data_date_type = $_POST['data_date_type'];
    $data_since_date = $_POST['data_since_date'];
    $data_to_date = $_POST['data_to_date'];
    $date_request = $block_picks_vs->get_date_filter($data_date_type, $data_since_date, $data_to_date);

    $api_url = get_field('picks_vs_api_url', 'option');
    $api_token = get_field('picks_vs_api_token', 'option');
    
    list($cat_primary, $cat_secondary) = explode('-', $id_sub_category);
    $key = $cat_primary.':'.$cat_secondary.':'.str_replace('/', ':', $date_request).':'.$items;

    if ($rdgb->helpers->init_redis()) {
        $rdgb->helpers->set_redis_group(REDIS_GROUP_BLOCKS);
        $data_block = $rdgb->helpers->get_redis($key);

        if (!empty($data_block)) {
            $picks = unserialize($data_block);

            require 'partials/api.php';
            wp_die();
        }
    }

    if (!empty($api_url) && !empty($api_token)) {
        $api_attributes = $block_picks_vs->get_api_attributes($items, ['category' => $id_sub_category, 'date' => $date_request]);
        $response = $block_picks_vs->get_resources_ajax($api_attributes);

        if (empty($response->message)) {
            $picks = $response->json;
        } else {
            $picks = null;
            $message = $response->message;
        }

        if ($rdgb->helpers->init_redis() && $picks !== null) {
            $rdgb->helpers->set_redis($key, serialize($picks), REDIS_TIMEOUT);
        }
    } else {
        $message = 'Configure API connection correctly.';
    }

    if (!empty($message)) {
        $message = 'Picks with these characteristics were not found.';
        require 'partials/message.php';
        wp_die();
    }

    require 'partials/api.php';

    wp_die();
}

$rdg_picks_vs_class = new Rdg_Blocks_Picks_Vs();
$rdg_picks_vs_class->init();

return $rdg_picks_vs_class;
