<?php foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="content">
                <div class="sport"><span><?php echo $pick->id_sport; ?></span></div>
                <div class="date-time"><span><?php echo $pick->game_date; ?></span></div>
                <div class="status"><span><?php echo $pick->game_stat; ?></span></div>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team team-a">
                    <div class="team-logo">
                        <img src="<?php echo $block_picks_vs->get_image($pick->home_image); ?>" alt="">
                    </div>
                    <div class="team-name"><span><?php echo $pick->home_name; ?></span></div>
                </div>
                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                    <?php if ($custom_link_show == 'show'): ?>
                        <?php
                            $url = '';
                            $target = '_self';

                            if (is_array($custom_link)) {
                                if (isset($custom_link['url'])) {
                                    $url = $custom_link['url'];
                                }

                                if (isset($custom_link['target']) && !empty($custom_link['target'])) {
                                    $target = $custom_link['target'];
                                }
                            }
                        ?>
                        <a href="<?php echo $url; ?>" target="<?php echo $target; ?>">
                    <?php endif; ?>
                        <div class="vs-name">
                            <span><?php echo $pick->numPicks; ?> PICKS</span>
                        </div>
                    <?php if ($custom_link_show == 'show'): ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="team team-b">
                    <div class="team-logo">
                        <img src="<?php echo $block_picks_vs->get_image($pick->visitor_image); ?>" alt="">
                    </div>
                    <div class="team-name"><span><?php echo $pick->visitor_name; ?></span></div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>
