<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_TOP_CAPPERS;
    $block_classes = [$block_name];
    $block_top_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $primary_capper = 0;
    $titles = get_field('titles');
    $title = (!empty(get_field('title'))) ? get_field('title') : '';
    $cappers = (!empty(get_field('cappers'))) ? get_field('cappers') : [];
    $source = get_field('source');
    $display_block = (!empty(get_field('display_block'))) ? get_field('display_block') : 'full-width';
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    if ($source == 'api' && $block_top_cappers->is_caching()) {
        $api_url = get_field('top_cappers_api_url', 'option');
        $api_token = get_field('top_cappers_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_top_cappers->get_api_attributes($items);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id, $block_custom_id);
            $response = $block_top_cappers->get_resources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $cappers = $response->json;
            } else {
                $cappers = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $display_block; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (is_array($cappers) && count($cappers) > 0): ?>
                <?php
                    if ($source == 'api') {
                        require 'partials/api.php';
                    } else {
                        require 'partials/manual.php';
                    }
                ?>
            <?php else: ?>
                <?php if (!empty($message)): ?>
                    <span class="message"><?php echo $message; ?></span>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
