<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Main_Promotions extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_MAIN_PROMOTIONS;
    private $block_folder_name = 'rdg-main-promotions';
    private $block_title = 'RDG Main Promotions';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'main', 'promotion'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_main_promotions.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_main_promotions_block_d21e23r2d23d2',
                'title' => 'Block_rdg_main_promotions',
                'fields' => array(
                    array(
                        'key' => 'field_63d01ec3820ce',
                        'label' => 'Promotions',
                        'name' => 'promotions',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63d01ee1820cf',
                                'label' => 'Backgound Image',
                                'name' => 'backgound_image',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                                'parent_repeater' => 'field_63d01ec3820ce',
                            ),
                            array(
                                'key' => 'field_63d01ef7820d0',
                                'label' => 'Width',
                                'name' => 'width',
                                'aria-label' => '',
                                'type' => 'number',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => 100,
                                'min' => 1,
                                'max' => 100,
                                'placeholder' => '',
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63d01ec3820ce',
                            ),
                            array(
                                'key' => 'field_63d0212019a44',
                                'label' => 'Titles',
                                'name' => 'titles',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 0,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63d01f33820d1',
                                        'label' => 'Title',
                                        'name' => 'title',
                                        'aria-label' => '',
                                        'type' => 'wysiwyg',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'tabs' => 'all',
                                        'toolbar' => 'full',
                                        'media_upload' => 0,
                                        'delay' => 0,
                                        'parent_repeater' => 'field_63d0212019a44',
                                    ),
                                    array(
                                        'key' => 'field_63d01f8f820d3',
                                        'label' => 'Title Size',
                                        'name' => 'title_size',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 2,
                                        'min' => 1,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => 1,
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d0212019a44',
                                    ),
                                    array(
                                        'key' => 'field_63d025ca8aa74',
                                        'label' => 'Padding',
                                        'name' => 'padding',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 0,
                                        'min' => 0,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d0212019a44',
                                    ),
                                    array(
                                        'key' => 'field_63d025fb8aa75',
                                        'label' => 'Line Height',
                                        'name' => 'line_height',
                                        'aria-label' => '',
                                        'type' => 'number',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => 0,
                                        'min' => 0,
                                        'max' => 20,
                                        'placeholder' => '',
                                        'step' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63d0212019a44',
                                    ),
                                    array(
                                        'key' => 'field_63d01f68820d2',
                                        'label' => 'Title Color',
                                        'name' => 'title_color',
                                        'aria-label' => '',
                                        'type' => 'color_picker',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'enable_opacity' => 0,
                                        'return_format' => 'string',
                                        'parent_repeater' => 'field_63d0212019a44',
                                    ),
                                ),
                                'parent_repeater' => 'field_63d01ec3820ce',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-main-promotions',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_style($type, $fields) {
        $style = [];
    
        if ('block' == $type) {
            $color = (!empty($fields)) ? $fields : '#f4f5f4';
            $style[] = 'background-color: '.$color;
    
            return implode('; ', $style);
        }
    
        if ('heading' == $type) {
            $color = (!empty($fields['title_color'])) ? $fields['title_color'] : '#ffffff';
            $style[] = 'color: '.$color;
            $style[] = 'font-size: '.$fields['title_size'].'rem';
            $style[] = (!empty($fields['line_height'])) ? 'line-height: '.$fields['line_height'].'rem' : 'line-height: inherit' ;
            $style[] = (!empty($fields['padding'])) ? 'padding-bottom: '.$fields['padding'].'rem' : 'padding-bottom: 0' ;
    
            return implode('; ', $style);
        }
    
        return '';
    }
}

$rdg_main_promotions_class = new Rdg_Blocks_Main_Promotions();
$rdg_main_promotions_class->init();

return $rdg_main_promotions_class;
