(function() {
    const rdgPicksVs = document.querySelector('#rdg-picks-vs-category');
    rdgPicksVs.addEventListener('change', function(e) {
        e.preventDefault();
        // const rdgBlocks = document.querySelectorAll('.rdg-blocks');
        const items = e.target.getAttribute('data-items');
        const blockId = e.target.getAttribute('data-block-id');
        const catSelected = document.querySelector('#' + blockId + ' #rdg-picks-vs-category option:checked').value;
        const buttons = document.querySelectorAll('.buttons .link-info, .buttons .link-default');
        let ajax_url = rdg_picks_vs_var.ajaxurl;

        document.querySelector('#wait').style.display = 'block';

        let data = {'data_date_type':'', 'data_since_date':'', 'data_to_date':''};
        buttons.forEach(function(button) {
            if (button.classList.contains('link-info')) {
                data.data_date_type = button.getAttribute('data-date-type');
                data.data_since_date = button.getAttribute('data-since-date');
                data.data_to_date = button.getAttribute('data-to-date');
            }
        }, data);

        fetch(ajax_url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `action=load_picks_vs&items=${items}&id_sub_category=${catSelected}&data_date_type=${data.data_date_type}&data_since_date=${data.data_since_date}&data_to_date=${data.data_to_date}`
        })
        .then(response => response.text())
        .then(resultado => {
            document.querySelector('.rdg-blocks .picks').innerHTML = resultado;
            document.querySelector('#wait').style.display = 'none';
            setTimeout(function() {
                const messageElement = document.querySelector('.rdg-blocks .picks .message');
                if (messageElement) {
                    messageElement.style.display = 'none';
                }
            }, 3000);
        })
        .catch(error => console.error('Error:', error));
    });

    document.addEventListener('click', function(e) {
        if (e.target.matches('.rdg-picks-vs .buttons a') && !e.target.matches('.link-info')) {
            e.preventDefault();
            const blockId = e.target.getAttribute('data-block-id');
            const catSelected = document.querySelector('#' + blockId + ' #rdg-picks-vs-category option:checked').value;;
            const buttons = document.querySelectorAll('#' + blockId + ' .buttons .link-info, #' + blockId + ' .buttons .link-default');
            const buttonId = e.target.getAttribute('id');
            const items = e.target.getAttribute('data-items');
            const dataDateType = e.target.getAttribute('data-date-type');
            const dataSinceDate = e.target.getAttribute('data-since-date');
            const dataToDate = e.target.getAttribute('data-to-date');
            let ajax_url = rdg_picks_vs_var.ajaxurl;

            buttons.forEach(function(button) {
                if (button.getAttribute('id') === buttonId) {
                    button.classList.remove('link-default');
                    button.classList.add('link-info');
                } else {
                    button.classList.remove('link-info');
                    button.classList.add('link-default');
                }
            });

            document.getElementById('wait').style.display = 'block';
    
            fetch(ajax_url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `action=load_picks_vs&items=${items}&id_sub_category=${catSelected}&data_date_type=${dataDateType}&data_since_date=${dataSinceDate}&data_to_date=${dataToDate}`
            })
            .then(response => response.text())
            .then(resultado => {
                document.querySelector('.rdg-blocks .picks').innerHTML = resultado;
                document.getElementById('wait').style.display = 'none';
                setTimeout(function() {
                    let message = document.querySelector('.rdg-blocks .picks .message');
                    if (message) {
                    message.style.display = 'none';
                    }
                }, 3000);
                
            })
            .catch(error => console.error('Error:', error));
        }
    });    
})();