window.addEventListener('load', () => { 

// Pagination

const rdgPostsAjaxPagination = document.querySelector(".rdg-posts-ajax .posts-ajax-pagination a");

rdgPostsAjaxPagination.addEventListener("click", function(e) {
    e.preventDefault();
    
    const ajax_url = rdg_posts_ajax_var.ajaxurl;
    const page = e.target.getAttribute('data-page');
    const items = document.querySelector('#rdg-posts-ajax-sports').getAttribute('data-items');
    const block_id = document.querySelector('#rdg-posts-ajax-sports').getAttribute('data-block-id');
    const category_sport = document.querySelector('#'+block_id+' #rdg-posts-ajax-sports option:checked').value;
    const category_league = document.querySelector('#'+block_id+' #rdg-posts-ajax-leagues option:checked').value;

    fetch(ajax_url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: `action=load_posts_filters&items=${items}&category_sport=${category_sport}&category_league=${category_league}&block_id=${block_id}&page=${page}`,
    })
    .then(response => response.text())
    .then(result => {
        document.querySelector('.rdg-blocks .posts').innerHTML = result;
    })
    .catch(error => console.error('Error:', error));
});

// Load By Sports

const rdgPostsAjaxSports = document.querySelector('#rdg-posts-ajax-sports');

rdgPostsAjaxSports.addEventListener('change', function(e) {
    e.preventDefault();
    document.querySelectorAll('.rdg-blocks .rdg-posts-ajax .posts .message').forEach(function(el) {
        el.style.display = 'none';
    });

    let ajax_url = rdg_posts_ajax_var.ajaxurl;
    let items = e.target.getAttribute('data-items');
    let block_id = e.target.getAttribute('data-block-id');
    let cat_seleted = document.querySelector('#' + block_id + ' #rdg-posts-ajax-sports option:checked').value;
    let sport_redirect = document.querySelector('#' + block_id + ' #rdg-posts-ajax-sports option:checked').getAttribute('data-redirect');
    let type_redirect = e.target.getAttribute('data-sport-type');
    
    if (type_redirect == 'redirect') {
      if (sport_redirect != cat_seleted) {
        document.getElementById('wait').style.display = 'block';
        window.location.href = sport_redirect;
        return;
      }
    }

    document.getElementById('wait').style.display = 'block';
    
    var xhr = new XMLHttpRequest();
    xhr.open('POST', ajax_url, true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onreadystatechange = function() {
      if (xhr.readyState === 4 && xhr.status === 200) {
        var resultado1 = xhr.responseText;
    
        var xhr2 = new XMLHttpRequest();
        xhr2.open('POST', ajax_url, true);
        xhr2.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr2.onreadystatechange = function() {
          if (xhr2.readyState === 4 && xhr2.status === 200) {
            var resultado2 = xhr2.responseText;
    
            document.querySelector('.rdg-blocks #' + block_id + ' .posts').innerHTML = resultado1;
            document.querySelector('.rdg-blocks #' + block_id + ' #rdg-posts-ajax-leagues').innerHTML = resultado2;
            document.getElementById('wait').style.display = 'none';
            setTimeout(function() {
                let message = document.querySelector('.rdg-blocks #' + block_id + ' .posts .message');
                    if (message) {
                    message.style.display = 'none';
                    }
            }, 4000);
          }
        };
    
        xhr2.send('action=load_options_league&category=' + cat_seleted);
    
        setTimeout(function() {
            let message = document.querySelector('.rdg-blocks #' + block_id + ' .posts .message');
            if (message) {
            message.style.display = 'none';
            }
        }, 4000);
      }
    };
    
    xhr.send('action=load_posts_ajax&items=' + items + '&category=' + cat_seleted + '&block_id=' + block_id);
});

// Load By League

const rdgPostsAjaxLeagues = document.querySelector('#rdg-posts-ajax-leagues');

rdgPostsAjaxLeagues.addEventListener('change', function(e) {
    e.preventDefault();
    document.querySelectorAll('.rdg-blocks .rdg-posts-ajax .posts .message').forEach(function(el) {
        el.style.display = 'none';
    });

    const ajax_url = rdg_posts_ajax_var.ajaxurl;
    const items = e.target.getAttribute('data-items');
    const block_id = e.target.getAttribute('data-block-id');
    const cat_seleted_sport = document.querySelector(`#${block_id} #rdg-posts-ajax-sports option:checked`).value;
    const cat_seleted_league = document.querySelector(`#${block_id} #rdg-posts-ajax-leagues option:checked`).value;

    document.getElementById('wait').style.display = 'block';

    fetch(ajax_url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: `action=load_posts_filters&items=${items}&category_sport=${cat_seleted_sport}&category_league=${cat_seleted_league}&block_id=${block_id}`
        
    })
    .then(response => response.text())
    .then(resultado => {
        document.querySelector(`.rdg-blocks #${block_id} .posts`).innerHTML = resultado;
        document.getElementById('wait').style.display = 'none';
        setTimeout(function() {
            document.querySelectorAll(`.rdg-blocks #${block_id} .posts .message`).forEach(function(el) {
                el.style.display = 'none';
            });
        }, 4000);
    })
    .catch(error => console.error(error));
});
});

