<?php 
    global $rdgb;
    $block_styles = [];
    $block_classes = [BLOCK_RDG_PROS_CONS];
    $block_pros_cons = $rdgb->settings->get_block(BLOCK_RDG_PROS_CONS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $verified = (!empty(get_field('verified'))) ? get_field('verified') : 'hide';
    $verified_img = (!empty(get_field('image'))) ? get_field('image') : null;
    $verified_date = (!empty(get_field('date'))) ? get_field('date') : null;
    $image_site = (!empty(get_field('image_site'))) ? get_field('image_site') : null;
    $features = (!empty(get_field('features'))) ? get_field('features') : null;
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/heading.php'; ?>

            <div class="review">
                <?php if ($verified == 'show' && !empty($verified_img) && !empty($verified_date)): ?>
                <div class="verified">
                    <div class="logo">
                        <img src="<?php echo $verified_img['url']; ?>" alt="Image">
                    </div>
                    <span class="label"><?php echo __('Verified'); ?></span>
                    <span class="date"><?php echo $verified_date; ?></span>
                </div>
                <?php endif; ?>
                <div class="review-body">
                    <?php if (!empty($image_site)): ?>
                        <div class="image">
                            <img src="<?php echo $image_site['url']; ?>" alt="Image">
                        </div>
                    <?php endif; ?>
                    <div class="pros-cons">
                        <?php if (is_array($features) && count($features) > 0): ?>
                            <?php foreach($features as $feature): ?>
                                <?php if (is_array($feature['elements']) && count($feature['elements']) > 0): ?>
                                    <?php $heading_style = $block_pros_cons->get_style($feature, 'heading'); ?>
                                    <?php $items_style = $block_pros_cons->get_style($feature, 'items'); ?>
                                    <div class="group">
                                        <<?php echo $feature['heading']; ?> class="heading" style="<?php echo $heading_style; ?>"><?php echo $feature['title']; ?></<?php echo $feature['heading']; ?>>
                                        <ul>
                                            <?php foreach($feature['elements'] as $element): ?>
                                                <li style="<?php echo $items_style; ?>">
                                                    <span class="icon" style="<?php #echo $list_color; ?>">
                                                        <?php echo file_get_contents(RDGBLOCKS_PLUGIN_URL.'dist/images/'.$feature['style_elements']['list_style'].'.svg'); ?>
                                                    </span>
                                                    <<?php echo $feature['style_elements']['heading']; ?> class="value"><?php echo $element['text'] ?></<?php echo $feature['style_elements']['heading']; ?>>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
