<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_SPORTS_PICKS_VS;
    $block_classes = [$block_name];
    $block_sports_picks_vs = $rdgb->settings->get_block($block_name);
 
    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $source = get_field('source');
    $titles = get_field('titles');
    $picks = get_field('picks');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

    $sport_category = (!empty(get_field('category'))) ? get_field('category') : 1;
    $game_part_selected = (!empty(get_field('game_part'))) ? get_field('game_part') : null;
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : 'now';
    $date = (!empty(get_field('date'))) ? get_field('date') : null;
    $link = (!empty(get_field('link'))) ? get_field('link') : null;

    if ($source == 'api' && $block_sports_picks_vs->is_caching()) {
        $api_url = get_field('sports_picks_vs_api_url', 'option');
        $api_token = get_field('sports_picks_vs_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;
        
        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_sports_picks_vs->get_api_attributes($items, [
                'sport' => $sport_category,
                'game' => $game_part_selected,
                'date_type' => $date_type,
                'date' => $date,
            ]);

            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id, $block_custom_id);
            $response = $block_sports_picks_vs->get_resources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $picks = $response->json;
            } else {
                $picks = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (is_array($picks) && count($picks) > 0): ?>
                <div class="picks">
                    <?php if (!empty($picks)): ?>
                        <?php
                            if ($source == 'api') {
                                require 'partials/api.php';
                            } else {
                                require 'partials/manual.php';
                            }
                        ?>
                    <?php else: ?>
                        <?php if (!empty($message)): ?>
                            <span class="message"><?php echo $message; ?></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
