<?php
$logo_label = true;

if ($api_attributes['category_primary'] == 'MU') {
    $mu_sub_category = ['4', '14', '21', '25', '26', '31'];

    if (in_array($api_attributes['sub_category'], $mu_sub_category)) {
        $logo_label = false;
    }
}

if ($api_attributes['category_primary'] == 'TNT') {
    $mu_sub_category = ['4', '26', '27'];

    if (in_array($api_attributes['sub_category'], $mu_sub_category)) {
        $logo_label = false;
    }
}

?>
<?php foreach($picks as $pick):?>
    <div class="pick">
        <div class="pick-header">
            <div class="content">
                <div class="sport"><span><?php echo $pick['id_sport']; ?></span></div>
                <div class="date-time"><span><?php echo $pick['game_date']; ?></span></div>
                <div class="status"><span><?php echo $pick['game_stat']; ?></span></div>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team team-a">
                    <div class="team-logo">
                        <?php
                            $home_image = $block_picks_vs->get_image($pick['home_image'], [
                                'image_type' => 'team_image',
                                'image_alt' => $pick['home_name'],
                                'logo_label' => $logo_label
                            ]);
                        ?>
                        <img src="<?php echo $home_image['url']; ?>" alt="<?php echo $home_image['alt']; ?>">
                    </div>
                    <div class="team-name"><span><?php echo $pick['home_name']; ?></span></div>
                </div>
                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                    <?php if ($custom_link_show == 'show'): ?>
                        <?php
                            $url = '';
                            $target = '_self';

                            if (is_array($custom_link)) {
                                if (isset($custom_link['url'])) {
                                    $url = $custom_link['url'];
                                }

                                if (isset($custom_link['target']) && !empty($custom_link['target'])) {
                                    $target = $custom_link['target'];
                                }
                            }
                        ?>
                        <a href="<?php echo $url; ?>" target="<?php echo $target; ?>">
                    <?php endif; ?>
                        <div class="vs-name">
                            <span><?php echo $pick['numPicks']; ?> PICKS</span>
                        </div>
                    <?php if ($custom_link_show == 'show'): ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="team team-b">
                    <div class="team-logo">
                        <?php
                            $visitor_image = $block_picks_vs->get_image($pick['visitor_image'], [
                                'image_type' => 'team_image',
                                'image_alt' => $pick['visitor_name'],
                                'logo_label' => $logo_label
                            ]);
                        ?>
                        <img src="<?php echo $visitor_image['url']; ?>" alt="<?php echo $visitor_image['alt']; ?>">
                    </div>
                    <div class="team-name"><span><?php echo $pick['visitor_name']; ?></span></div>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>
