<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_PICKS_VS;
    $block_classes = [$block_name];
    $block_picks_vs = $rdgb->settings->get_block($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $items = 1;
    $picks = get_field('picks');
    $titles = get_field('titles');
    $source = get_field('source');
    $category = get_field('category');
    $custom_link_show = (!empty(get_field('custom_link_show'))) ? get_field('custom_link_show') : 'hide';
    $custom_link = (!empty(get_field('custom_link'))) ? get_field('custom_link') : null;

    $filter_category = (!empty(get_field('filter_category'))) ? get_field('filter_category') : 'hide';
    $filter_date = (!empty(get_field('filter_date'))) ? get_field('filter_date') : 'hide';
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;
    $date_ranges = (!empty(get_field('date_range'))) ? get_field('date_range') : [];
    $picks_titles = $block_picks_vs->get_picks_vs_titles(true);
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $date_request = $block_picks_vs->get_date_filter($date_type, $since_date, $to_date);
    $show = (!empty(get_field('show_in'))) ? get_field('show_in') : 'column';

    if ($source == 'api' && $block_picks_vs->is_caching()) {
        $api_url = get_field('picks_vs_api_url', 'option');
        $api_token = get_field('picks_vs_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_picks_vs->get_api_attributes($items, ['category' => $category, 'date' => $date_request]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id_custom, $block_custom_id);
            $response = $block_picks_vs->get_resources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $picks = $response->json;
            } else {
                $picks = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
    
    
    if (strpos($category, '-')) {
        list($category_primary, $sub_category) = explode('-', $category);
    } else {
        $sub_category = null;
        $category_primary = $category;
    }

    $styles_filter_style = $block_picks_vs->get_width('style', $filter_category, $filter_date);
    $styles_filter_class_category = $block_picks_vs->get_width('class_category', $filter_category, $filter_date);
    $styles_filter_class_sub_category = $block_picks_vs->get_width('class_sub_category', $filter_category, $filter_date);
?>

<div class="rdg-blocks">
    <div <?php echo (!empty($block_id)) ? 'id="'.$block_id.'"' : ''; ?> class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $show; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div id="wait"></div>
            <?php if ($source == 'api'): ?>
                <?php if ($filter_category == 'show' || $filter_date == 'show'): ?>
                    <div class="filter" style="<?php echo $styles_filter_style; ?>">
                        <?php if ($filter_category == 'show'): ?>
                            <div class="categories <?php echo $styles_filter_class_category; ?>">
                                <div class="select">
                                    <select id="rdg-picks-vs-category" data-items="<?php echo $items; ?>" data-block-id="<?php echo $block_id; ?>" data-custom-link-show="<?php echo $custom_link_show; ?>" data-custom-link-url="<?php echo $custom_link['url']; ?>" data-custom-link-target="<?php echo $custom_link['target']; ?>">
                                        <?php foreach ($picks_titles as $pick_key => $pick_title): ?>
                                            <?php if (is_array($pick_title)): ?>
                                                <optgroup label="<?php echo $pick_key; ?>">
                                            <?php endif; ?>

                                            <?php if (is_array($pick_title)): ?>
                                                <?php foreach ($pick_title as $key => $sub_titles ): ?>
                                                    <?php $select = ''; ?>
                                                    <?php if ($key == $category_primary.'-'.$sub_category): ?>
                                                        <?php $select = 'selected'; ?>
                                                    <?php endif; ?>
                                                    
                                                    <option value="<?php echo $key; ?>" <?php echo $select; ?>><?php echo $sub_titles; ?></option>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <?php $select = ''; ?>
                                                <?php if ($pick_key == $category_primary): ?>
                                                    <?php $select = 'selected'; ?>
                                                <?php endif; ?>
                                                <option value="<?php echo $select; ?>" <?php echo $select; ?>><?php echo $pick_title; ?></option>
                                            <?php endif; ?>

                                            <?php if (is_array($pick_title)): ?>
                                                </optgroup>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($filter_date == 'show'): ?>
                            <div class="sub-categories <?php echo $styles_filter_class_sub_category; ?>">
                                <?php if (is_array($date_ranges) && count($date_ranges)): ?>
                                    <div class="buttons">
                                        <?php $i = 1; $status = false; ?>
                                        <?php foreach($date_ranges as $date_range): ?>
                                            <?php
                                                $icon = (!empty($date_range['icon'])) ? '<i class="fal '.$date_range['icon'].'"></i>' : '';
                                            ?>
                                            <?php if (!empty($date_range['title_date'])): ?>
                                                <?php
                                                    if ($date_range['status'] == 'link-info') {
                                                        if ($status) {
                                                            $date_range['status'] = 'link-default';
                                                        } else {
                                                            $status = true;
                                                        }
                                                    } 
                                                ?>
                                                <a id="rdg_picks_vs_button_<?php echo $i; ?>" href="#" class="<?php echo $date_range['status']; ?>" data-items="<?php echo $items; ?>" data-date-type="<?php echo $date_range['date_type']; ?>" data-since-date="<?php echo $date_range['since_date']; ?>" data-to-date="<?php echo $date_range['to_date']; ?>" data-block-id="<?php echo $block_id; ?>" data-category="<?php echo $category; ?>" data-custom-link-show="<?php echo $custom_link_show; ?>" data-custom-link-url="<?php echo $custom_link['url']; ?>" data-custom-link-target="<?php echo $custom_link['target']; ?>"><?php echo $date_range['title_date']; echo $icon;?></a>
                                            <?php endif; ?>
                                            <?php $i++; ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($picks) && count($picks) > 0): ?>
                <div class="picks">
                    <?php if (!empty($picks)): ?>
                        <?php
                            if ($source == 'api') {
                                require 'partials/api.php';
                            } else {
                                require 'partials/manual.php';
                            }
                        ?>
                    <?php else: ?>
                        <?php if (!empty($message)): ?>
                            <span class="message"><?php echo $message; ?></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
