<?php 
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_PREVIEWS_AND_PREDICTIONS;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    // Variables
    $title = get_field('title');
    $previewsBtn = get_field('previews_btn');
    $previewsLink = get_field('previews_link');
    $recapsBtn = get_field('recaps_btn');
    $recapsLink = get_field('recaps_link');

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <div class="column">
                <div class="header">
                    <?php echo $title; ?>
                </div>
                <div class="main">
                <?php 
                    // Check rows exists.
                        if( have_rows('vs_list') ):
            
                    // Loop through rows.
                    while( have_rows('vs_list') ) : the_row();
                
                        // Load sub field value.
                        $teamA = get_sub_field('team_a');
                        $teamB = get_sub_field('team_b');
                        // Do something...
                ?>
                    <div class="list">
                        <div class="first-team-name"><?php echo $teamA; ?></div>
                        <div class="versus">vs.</div>
                        <div class="second-team-name"><?php echo $teamB; ?></div>
                    </div>

                    <?php 
                    // End loop.
                    endwhile;
                endif; ?>
                    </div>
                    <div class="footer">
                    <a href="<?php echo $previewsLink; ?>" class="btn"><?php echo $previewsBtn; ?></a>
                    <a href="<?php echo $recapsLink; ?>" class="btn"><?php echo $recapsBtn; ?></a>
                    </div>
            </div>
        </div>
    </div>
</div>
