<?php 
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_POSTS_LIST;
    $block_classes = [$block_name];
    $block_posts_list = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $detail = (!empty(get_field('detail'))) ? get_field('detail') : '';
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $elements = $block_posts_list->get_elements_type(get_fields());
    $show = get_field('show');
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <div class="body">
            <?php if (is_array($elements) && count($elements) > 0): ?>
                <div class="items">
                    <?php foreach($elements as $element): ?>
                        <div class="item">
                            <?php
                                $image = '';
                                if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                    $image = $block_posts_list->get_image($element->ID);
                                } else {
                                    if (isset($element['image']['url']) && !empty($element['image']['url'])) {
                                        $image = $element['image']['url'];
                                    }
                                }
                            ?>
                            <div class="header">
                                <div class="date">
                                    <?php
                                        $date = (!empty($element->post_date)) ? $element->post_date : $element['date'];

                                        try {
                                            $d = DateTime::createFromFormat('Y-m-d H:i:s', $date);
                                            $date_status = $d && $d->format('Y-m-d H:i:s') == $date;

                                            if ($date_status) {
                                                $date = $d->format('F j, Y');
                                            }
                                        } catch (\Exception $exception) {
                                            //
                                        }
                                    ?>
                                    <?php echo $date; ?>
                                </div>
                                <div class="detail">
                                    <?php
                                        if (!in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                            if (isset($element['detail']) && !empty($element['detail'])) {
                                                $detail = $element['detail'];
                                            }
                                        }
                                    ?>
                                    <?php echo $detail; ?>
                                </div>
                            </div>
                                <?php
                                    $link_url = '';
                                    $link_target = '_self';
                                    $link_name = 'Read more';
                                    if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                        $link_url = get_permalink($element);
                                    } else {
                                        if (isset($element['link_post']['url']) && !empty($element['link_post']['url'])) {
                                            $link_url = $element['link_post']['url'];
                                        }

                                        if (isset($element['link_post']['target']) && !empty($element['link_post']['target'])) {
                                            $link_target = $element['link_post']['target'];
                                        }

                                        if (isset($element['link_post']['title']) && !empty($element['link_post']['title'])) {
                                            $link_name = $element['link_post']['title'];
                                        }
                                    } 
                                ?>
                                <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                                    <div class="image" style="background-image: url(<?php echo $image; ?>);"></div>
                                </a>
                            <footer>
                                <div class="footer-title">
                                    <a href="<?php echo $link_url; ?>" target="<?php echo $link_target; ?>">
                                        <?php echo (!empty($element->post_title)) ? $element->post_title : $element['title']; ?>
                                    </a>
                                </div>
                                <?php
                                    $excerpt = '';
                                    if (in_array($show, [BLOCK_RDG_TYPE_LATEST, BLOCK_RDG_TYPE_SPECIFIC]) ) {
                                        if (!empty($element->post_excerpt)) {
                                            $excerpt = $element->post_excerpt;
                                        } else {
                                            $excerpt = $element->post_content;
                                        }
                                    } else {
                                        if (isset($element['content']) && !empty($element['content'])) {
                                            $excerpt = $element['content'];
                                        }
                                    }
                                ?>
                                <?php if (!empty($excerpt)): ?>
                                    <div class="footer-description">
                                        <?php echo wp_trim_words($excerpt, 35, false); ?>
                                    </div>
                                <?php endif; ?>
                            </footer>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
