<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Sports_Picks_Vs extends Rdg_Blocks_Base implements Rdg_Blocks_Api_Request
{
    protected $block_name = BLOCK_RDG_SPORTS_PICKS_VS;
    private $block_folder_name = 'rdg-sports-picks-vs';
    private $block_title = 'RDG Sports Picks Vs';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'sports', 'picks', 'vs'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = true;
    protected $is_config = true;
    protected $config_page_title = 'RDG Sports Picks Vs';
    protected $config_menu_title = 'Sports Picks Vs';
    protected $config_menu_order = 9;

    public function init() {
        $this->register_block();
        add_action('acf/init', [$this, 'register_config_menu'], 20);
        add_action('acf/init', [$this, 'register_fields'], 20);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_script'], 20);
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_sports_picks_vs.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function enqueue_admin_script($hook) {
        wp_register_script('rdg_sports_picks_vs_script', RDGBLOCKS_PLUGIN_URL.'blocks/rdg-sports-picks-vs/assets/js/rdg-sports-picks-vs.js', array('jquery'), '1', true);
        wp_enqueue_script('rdg_sports_picks_vs_script');
        wp_localize_script('rdg_sports_picks_vs_script','rdg_sports_picks_vs_var',['ajaxurl' => admin_url('admin-ajax.php')]);
    }

    public function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_rdg_sports_picks_vs_block_serffsdfsfdf',
                'title' => 'Block_rdg_sports_picks_vs',
                'fields' => array(
                    array(
                        'key' => 'field_6466295e2c53d',
                        'label' => 'Source',
                        'name' => 'source',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'manual' => 'Manual',
                            'api' => 'API',
                        ),
                        'default_value' => 'manual',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'field_63c0765368257',
                        'label' => 'Picks',
                        'name' => 'picks',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'manual',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_63c0765389857',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                            array(
                                'key' => 'field_63c076539bd5b',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 0,
                                'max' => 2,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_63c07653b655e',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c07653b9f7b',
                                        'label' => 'Odds',
                                        'name' => 'odds',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c094f2bc9e8',
                                        'label' => 'Opener',
                                        'name' => 'opener',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c09538bc9e9',
                                        'label' => 'Current',
                                        'name' => 'current',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                    array(
                                        'key' => 'field_63c0955dbc9ea',
                                        'label' => 'Money Line',
                                        'name' => 'money_line',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_63c076539bd5b',
                                    ),
                                ),
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                            array(
                                'key' => 'field_63c095b6bc9eb',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                            array(
                                'key' => 'field_63c07653a3263',
                                'label' => 'Link',
                                'name' => 'link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'parent_repeater' => 'field_63c0765368257',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_64662bda2c53e',
                        'label' => 'Sport',
                        'name' => 'category',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => 'sport_picks_vs_sports_categories',
                        ),
                        'choices' => $this->get_sports_picks_vs_sports(),
                        'default_value' => '',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 1,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64662f7bc972f',
                        'label' => 'Game Part',
                        'name' => 'game_part',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => 'sport_picks_vs_game_parts',
                        ),
                        'choices' => null,
                        'default_value' => '',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64662e1c8a863',
                        'label' => 'Date Type',
                        'name' => 'date_type',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'yesterday' => 'Yesterday',
                            'now' => 'Now',
                            'tomorrow' => 'Tomorrow',
                            'range' => 'Specific Date',
                        ),
                        'default_value' => 'now',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64662eaf8a864',
                        'label' => 'Date',
                        'name' => 'date',
                        'aria-label' => '',
                        'type' => 'date_picker',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64662e1c8a863',
                                    'operator' => '==',
                                    'value' => 'range',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'display_format' => 'd/m/Y',
                        'return_format' => 'Y-m-d',
                        'first_day' => 1,
                    ),
                    array(
                        'key' => 'field_64662c0d2c53f',
                        'label' => 'Number of Items',
                        'name' => 'number_of_items',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 100,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6488637660ae7',
                        'label' => 'Picks Link',
                        'name' => 'picks_link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'field_64662c472c540',
                        'label' => 'All Link',
                        'name' => 'link',
                        'aria-label' => '',
                        'type' => 'link',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_6466295e2c53d',
                                    'operator' => '==',
                                    'value' => 'api',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-sports-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function register_config_menu() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'api_configuration_sports_picks_vs_block_awedddadads',
                'title' => 'API configuration',
                'fields' => array(
                    array(
                        'key' => 'field_64665c60064d2',
                        'label' => 'URL',
                        'name' => 'sports_picks_vs_api_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '70',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64665cbb064d3',
                        'label' => 'Cache Refresh Frequency (Hours)',
                        'name' => 'sports_picks_vs_interval',
                        'aria-label' => '',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 1,
                        'min' => 1,
                        'max' => 10,
                        'placeholder' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64665cf1064d4',
                        'label' => 'Token',
                        'name' => 'sports_picks_vs_api_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '70',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_64665derwrwerewr',
                        'label' => 'Sports Categories',
                        'name' => 'sports_picks_vs_sports_categories',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64665d47064d6',
                                'label' => 'Sport ID',
                                'name' => 'sports_picks_vs_sport_id',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64665d19064d5',
                            ),
                            array(
                                'key' => 'field_64665d8e064d8',
                                'label' => 'Sport Name',
                                'name' => 'sports_picks_vs_sport_name',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64665d19064d5',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_64wrwrwrwer',
                        'label' => 'Sports Game Parts',
                        'name' => 'sports_picks_vs_sports_game_parts',
                        'aria-label' => '',
                        'type' => 'repeater',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'pagination' => 0,
                        'min' => 0,
                        'max' => 0,
                        'collapsed' => '',
                        'button_label' => 'Add Row',
                        'rows_per_page' => 20,
                        'sub_fields' => array(
                            array(
                                'key' => 'field_64665e9022479',
                                'label' => 'Sport ID',
                                'name' => 'sports_picks_vs_sport_id',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '25',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64665e9022478',
                            ),
                            array(
                                'key' => 'field_64665ed02247b',
                                'label' => 'Game Part ID',
                                'name' => 'sports_picks_vs_game_part_id',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '25',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64665e9022478',
                            ),
                            array(
                                'key' => 'field_64665e902247a',
                                'label' => 'Game Part Name',
                                'name' => 'sports_picks_vs_game_part_name',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'parent_repeater' => 'field_64665e9022478',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sports-picks-vs',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    public function get_api_attributes($items = null, $attributes = []) {
        $api_url = get_field('sports_picks_vs_api_url', 'option');
        $api_token = get_field('sports_picks_vs_api_token', 'option');
        $cache_refresh = get_field('sports_picks_vs_interval', 'option');
        $items = (!empty($items)) ? intval($items) : 10;

        $api_url = (substr($api_url, -1) == '/') ? substr($api_url, 0, strlen($api_url) -1) : $api_url;

        if (isset($attributes['date_type']) && !empty($attributes['date_type'])) {
            if ($attributes['date_type'] == 'yesterday') {
                $api_url .= '?date='.date('Y-m-d', strtotime("-1 days"));
            } elseif ($attributes['date_type'] == 'now') {
                $api_url .= '?date='.date('Y-m-d');
            } elseif ($attributes['date_type'] == 'tomorrow') {
                $api_url .= '?date='.date('Y-m-d', strtotime("+1 days"));
            } else {
                if (!empty($attributes['date'])) {
                    $api_url .= '?date='.$attributes['date'];
                } else {
                    $api_url .= '?date='.date('Y-m-d');
                }
            }
        } else {
            $api_url .= '?date='.date('Y-m-d');
        }
        
        $api_url .= '&recordsQty='.$items;
        $api_url .= '&completeGames=1';

        if (isset($attributes['sport']) && !empty($attributes['sport'])) {
            $sport = $attributes['sport'];
        } else {
            $sport = null;
        }

        if (!empty($sport)) {
            $api_url .= '&sport='.$sport;
        }

        if (isset($attributes['game']) && !empty($attributes['game'])) {
            $game_part = $attributes['game'];
        } else {
            $game_part = null;
        }

        if (!empty($game_part)) {
            $api_url .= '&gamePart='.$game_part;
        }

        $api_request = $api_url.'&api_token='.$api_token;

        return [
            'items' => $items,
            'method' => 'GET',
            'cache_refresh' => $cache_refresh,
            'headers' => ['Accept: application/json'],
            'request' => $api_request,
        ];
    }

    public function get_api_params() {
        return [
            'sport' => 'category',
            'game' => 'game_part',
            'date_type' => 'date_type',
            'date' => 'date',
        ];
    }

    public function get_resources($request, $cache_file) {
        $data = new StdClass();
        $data->json = '';
        $data->message = '';
        $rdgb_helpers = New Rdg_Blocks_Helpers;

        $sport_picks_vs = $rdgb_helpers->get_api_data($this->block_name, $cache_file, $request);

        if (!empty($sport_picks_vs->message)) {
            $data->message = $sport_picks_vs->message;
        
            return $data;
        }

        $data->json = $sport_picks_vs->json;

        return $data;
    }

    public function get_image($url_image, $attributes = []) {
        $rdgb_helpers = New Rdg_Blocks_Helpers;
        $url_image = $rdgb_helpers->get_image_source($url_image, $attributes);

        return $url_image;
    }

    public function get_sports_picks_vs_sports() {
        $sports = [];
        $sports_categories = get_field('sports_picks_vs_sports_categories', 'option');

        if (is_array($sports_categories) && count($sports_categories) > 0) {
            foreach ($sports_categories as $category) {
                $sports[$category['sports_picks_vs_sport_id']] = $category['sports_picks_vs_sport_name'];
            }
        }

        return $sports;
    }

    public function get_sports_picks_vs_game_parts($sport, $game_part) { 
        $game_parts = '';
        $game_parts_all = get_field('sports_picks_vs_sports_game_parts', 'option');

        foreach ($game_parts_all as $parts) {
            if ($parts['sports_picks_vs_sport_id'] == $sport ) {
                $selected = ($parts['sports_picks_vs_game_part_id'] == $game_part) ? ' seleted' : '';
                $game_parts .= '<option value="'.$parts['sports_picks_vs_game_part_id'].'"'.$selected.'>'.$parts['sports_picks_vs_game_part_name'].'</option>';
            }
        }

        return $game_parts;
    }
}

add_action('wp_ajax_nopriv_load_sports_categories','sports_picks_vs_game_parts');
add_action('wp_ajax_load_sports_categories','sports_picks_vs_game_parts');

function sports_picks_vs_game_parts() {
    $sport = $_POST['sport'];
    $part = isset($_POST['part']) ? $_POST['part'] : '';

    if (empty($sport)) {
        wp_die();
    }

    $game_parts_all = get_field('sports_picks_vs_sports_game_parts', 'option');

    if (!is_array($game_parts_all) || count($game_parts_all) == 0) {
        wp_die();
    }

    echo '<option value="">- Select -</option>';
    
    foreach ($game_parts_all as $parts) {
        if ($parts['sports_picks_vs_sport_id'] == $sport ) {
            $selected = '';
            if (!empty($part) && $parts['sports_picks_vs_game_part_id'] == $part) {
                $selected = ' selected';
            }
            echo '<option value="'.$parts['sports_picks_vs_game_part_id'].'"'.$selected.'>'.$parts['sports_picks_vs_game_part_name'].'</option>';
        }
    }

    wp_die();
}

function my_acf_load_field($field) {
    global $post;

    if (isset($post->post_content) && !empty($post->post_content)) {
        $blocks = parse_blocks($post->post_content);

        $array = [];
        $sport_picks_vs_blocks = getSportsPickVsBlock($blocks, $array);
    
        if (is_array($sport_picks_vs_blocks) && count($sport_picks_vs_blocks) > 0) {
            $field['wrapper']['data-selected'] = $sport_picks_vs_blocks[0]['part'];
        }
    }

    return $field;
}

add_filter('acf/load_field/name=game_part', 'my_acf_load_field');

function getSportsPickVsBlock($blocks, &$array) {
    foreach ($blocks as $block) {
        if (!empty($block['blockName']) && $block['blockName'] == 'acf/rdg-sports-picks-vs') {
            $game_part = getGamePart($block);

            if (!empty($game_part)) {
                $array[] = $game_part;
            }
        } elseif(is_array($block['innerBlocks']) && count($block['innerBlocks']) > 0) {
            getSportsPickVsBlock($block['innerBlocks'], $array);
        }
    }

    return $array;
}

function getGamePart($block) {
    if (isset($block['attrs']['data']['game_part']) && $block['attrs']['data']['game_part'] != '') {
        return [
            'part' => $block['attrs']['data']['game_part']
        ];
    }

    return null;
}

$rdg_sports_picks_vs_class = new Rdg_Blocks_Sports_Picks_Vs();
$rdg_sports_picks_vs_class->init();

return $rdg_sports_picks_vs_class;
