<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_ADMIN_CAPPERS_SIMPLE;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->get_block($block_name);
    $block_id = (isset($block['data']['custom_id']) && !empty($block['data']['custom_id'])) ? 
        $block['data']['custom_id'] : $block['id'];

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $cappers = get_field('cappers');
    $category = get_field('category');
    $links = get_field('links');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    
    $source = get_field('source');
    $show = (!empty(get_field('show_in'))) ? get_field('show_in') : 'full';
    $custom_link_show = (!empty(get_field('custom_link_show'))) ? get_field('custom_link_show') : 'hide';
    $custom_link = (!empty(get_field('custom_link'))) ? get_field('custom_link') : null;
    $date_type = (!empty(get_field('date_type'))) ? get_field('date_type') : null;
    $since_date = (!empty(get_field('since_date'))) ? get_field('since_date') : null;
    $to_date = (!empty(get_field('to_date'))) ? get_field('to_date') : null;
    $date_request = $block_admin_cappers->get_date_filter($date_type, $since_date, $to_date);
    $titles_sports = $rdgb->helpers->get_sporst_categories_titles(true);

    if ($source == 'api' && $block_admin_cappers->is_caching()) {
        $api_url = get_field('admin_cappers_simple_api_url', 'option');
        $api_token = get_field('admin_cappers_simple_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_admin_cappers->get_api_attributes($items, ['category' => $category, 'date' => $date_request]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id_custom, $block_custom_id);
            $response = $block_admin_cappers->get_resources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $cappers = $response->json;
            } else {
                $cappers = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <div <?php echo (!empty($block_id)) ? 'id="'.$block_id.'"' : ''; ?> class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $show; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <div class="cappers">
                <?php if (is_array($cappers) && count($cappers) > 0): ?>
                    <?php
                        if ($source == 'api') {
                            require 'partials/api.php';
                        } else {
                            require 'partials/manual.php';
                        }
                    ?>
                <?php else: ?>
                    <?php if (!empty($message)): ?>
                        <span class="message"><?php echo $message; ?></span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

        </div>
    </div>
</div>
