<div class="buttons">
    <?php foreach($items as $item): ?>
        <?php if (is_array($item['link']) && $item['link']['url'] != ''): ?>
            <a href="<?php echo $item['link']['url']; ?>" target="<?php echo (!empty($item['link']['target'])) ? $item['link']['target'] : '_self'; ?>">
        <?php endif; ?>

        <?php if ($item['type'] == 'image'): ?>
            <div class="item-button image-type">
                <?php
                    $item_bg = (!empty($item['background_color'])) ? $item['background_color'] : 'none';
                    $item_padding = (!empty($item['padding_button'])) ? $item['padding_button'].'rem' : '0';
                ?>
                <div class="body <?php echo (!is_array($item['texts']) || count($item['texts']) == 0) ? 'center' : ''; ?>" style="--body-bg: <?php echo $item_bg; ?>; --body-padding: <?php echo $item_padding; ?>;">
                    <?php if (!empty($item['image']['url'])): ?>
                        <div class="image">
                            <img src="<?php echo $item['image']['url']; ?>" alt="Image">
                        </div>
                    <?php endif; ?>
                    <?php if (is_array($item['texts']) && count($item['texts']) > 0): ?>
                        <div class="texts" style="<?php echo (!empty($item['image']['url'])) ? '--texts-with: calc(100% - 4rem);' : '--texts-with: calc(100%);'; ?>">
                            <?php foreach($item['texts'] as $text): ?>
                                <?php if (!empty($text['text'])): ?>
                                    <?php
                                        $title = $text['text'];
                                        $size = (!empty($text['size'])) ? $text['size'].'rem;' : '2rem;';
                                        $weight = (!empty($text['weight'])) ? $text['weight'].';' : '500;';
                                        $color = (!empty($text['color'])) ? $text['color'].';' : '#FFFFFF;';
                                        $text_padding = (!empty($text['text_padding'])) ? $text['text_padding'].'rem;' : '0;';
                                    ?>
                                    <span style="--text-size:<?php echo $size; ?> --text-padding:<?php echo $text_padding; ?> --text-weight:<?php echo $weight; ?> --text-color:<?php echo $color; ?>"><?php echo $title; ?></span>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <?php if (!empty($item['text_basic'])): ?>
                <?php
                    $padding = (!empty($item['padding'])) ? $item['padding'].'rem;' : '.5rem;';
                    $title = (!empty($item['text_basic'])) ? $item['text_basic'] : 'Link To';
                    $size = (!empty($item['size_basic'])) ? $item['size_basic'].'rem;' : '2rem;';
                    $weight = (!empty($item['weight_basic'])) ? $item['weight_basic'].';' : '500;';
                    $color = (!empty($item['color_basic'])) ? $item['color_basic'].';' : '#FFFFFF;';

                    $style = '';
                    if ($item['style'] == 'custom') {
                        $border_color = (!empty($item['border_color'])) ? $item['border_color'].';' : '#3a96e0;';
                        $background_color = (!empty($item['background_color_button'])) ? $item['background_color_button'].';' : '#0160ac;';
                        $hover_color = (!empty($item['hover_color'])) ? $item['hover_color'].';' : '#03467d;';
                    } else {
                        $style = $item['style'];
                        $border_color = '';
                        $background_color = '';
                        $hover_color = '';
                    }

                ?>

                <?php if ($item['style'] == 'custom'): ?>
                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?> --button-bg:<?php echo $background_color; ?> --button-hover:<?php echo $hover_color; ?>  --button-border:<?php echo $border_color; ?>">
                        <span><?php echo $title; ?></span>
                    </div>
                <?php else: ?>
                    <div class="item-button basic-type <?php echo $style; ?>" style="--button-padding:<?php echo $padding; ?> --button-size:<?php echo $size; ?> --button-weight:<?php echo $weight; ?> --button-color:<?php echo $color; ?>">
                        <span><?php echo $title; ?></span>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>

        <?php if (is_array($item['link']) && $item['link']['url'] != ''): ?>
            </a>
        <?php endif; ?>
    <?php endforeach; ?>
</div>