<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_PICKS_LIST;
    $block_classes = [$block_name];
    $block_picks_list = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $picks = get_field('picks');
    $links = get_field('links');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $show_type = (!empty(get_field('show'))) ? get_field('show') : 'show-default';
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container <?php echo $show_type; ?>">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($picks) && count($picks) > 0): ?>
                <div class="picks">
                    <?php foreach($picks as $pick):?>
                        <div class="pick">
                            <div class="pick-header">
                                <span class="title"><?php echo $pick['title']; ?></span>
                            </div>

                            <div class="content">
                                <div class="pick-content">
                                    <span class="heading-1"><?php echo $pick['heading_1']; ?></span>
                                    <span class="heading-2"><?php echo $pick['heading_2']; ?></span>
                                </div>

                                <?php if (!empty($pick['description'])): ?>
                                    <div class="pick-description"><?php echo $pick['description']; ?> </div>
                                <?php endif; ?>

                                <?php if (!empty($pick['list'])): ?>
                                    <div class="pick-list"><?php echo $pick['list']; ?> </div>
                                <?php endif; ?>

                                <?php if (!empty($pick['link'])): ?>
                                    <div class="pick-link">
                                        <a href="<?php echo $pick['link']['url']; ?>" target="<?php echo (!empty($pick['link']['target'])) ? $pick['link']['target'] : '_self'; ?>"><?php echo $pick['link']['title']; ?></a>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if (is_array($links) && count($links) > 0): ?>
                <div class="buttons">
                    <?php foreach($links as $link): ?>
                        <?php
                            $link_class = '';
                            $link_style = '';
                            if ($link['default_styles'] != 'custom') {
                                $link_class = 'class="'.$link['default_styles'].'"';
                            } else {
                                $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_picks_list->get_style('buttons', $link).'"';
                            }
                        ?>
                        <?php if (!empty($link['link']['url']) && $link['link']['title']): ?>
                            <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
