<?php
    global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_CONSENSUS;
    $block_classes = [$block_name];
    $block_consensus = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $titles = get_field('titles');
    $picks = get_field('picks');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($picks)): ?>
                <div class="picks">
                    <?php foreach($picks as $pick):?>
                        <div class="pick">
                            <div class="pick-header">
                                <div class="title">
                                    <span class="header-title"><?php echo $pick['title']; ?></span>
                                </div>
                            </div>
                            <div class="pick-body">
                                <?php if (isset($pick['teams']) && $pick['teams'] != false && count($pick['teams']) > 0 && count($pick['teams']) == 2): ?>
                                    <div class="teams">
                                        <?php $teams = 0; ?>
                                        <?php foreach($pick['teams'] as $team): ?>
                                            <?php $class_team = ($teams == 0) ? 'team-a' : 'team-b'; ?>

                                            <div class="team <?php echo $class_team; ?>">
                                                <div class="team-logo">
                                                    <?php if (isset($team['logo']['url']) && $team['logo']['url'] != ''): ?>
                                                        <img src="<?php echo $team['logo']['url']; ?>" alt="">
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <?php if ($teams == 0): ?>
                                                <div class="team team-vs">
                                                    <div class="vs-logo"><span>vs</span></div>
                                                </div>
                                            <?php endif;?>

                                            <?php $teams++; ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>

                                <div class="consensus">
                                    <?php echo __('CONSENSUS'); ?>
                                </div>

                                <div class="sections">
                                    <div class="section">
                                        <div class="header">
                                            <div class="title">
                                                SPREAD
                                            </div>
                                            <div class="totals">
                                                Totals
                                            </div>
                                            <div class="public">
                                                Public
                                            </div>
                                            <div class="sharp">
                                                Sharp
                                            </div>
                                        </div>
                                        <div class="data">
                                            <div class="leyend">
                                                <div class="leyend-items">
                                                    <div class="value">555</div>
                                                    <div class="title">DAL</div>
                                                </div>
                                                <div class="leyend-items">
                                                    <div class="value">555</div>
                                                    <div class="title">NEW</div>
                                                </div>
                                            </div>
                                            <div class="columns">
                                                <div class="totals">
                                                    <div class="totals-items">
                                                        <div class="value">333</div>
                                                        <div class="title">$61,739</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">41</div>
                                                        <div class="title">$2,229</div>
                                                    </div>
                                                </div>
                                                <div class="public">
                                                    <div class="totals-items">
                                                        <div class="value">324</div>
                                                        <div class="title">$60,996</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">36</div>
                                                        <div class="title">$1,659</div>
                                                    </div>
                                                </div>
                                                <div class="sharp">
                                                    <div class="totals-items">
                                                        <div class="value">9</div>
                                                        <div class="title">$741</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">5</div>
                                                        <div class="title">$570</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="section">
                                        <div class="header">
                                            <div class="title">
                                                SPREAD
                                            </div>
                                            <div class="totals">
                                                Totals
                                            </div>
                                            <div class="public">
                                                Public
                                            </div>
                                            <div class="sharp">
                                                Sharp
                                            </div>
                                        </div>
                                        <div class="data">
                                            <div class="leyend">
                                                <div class="leyend-items">
                                                    <div class="value">555</div>
                                                    <div class="title">DAL</div>
                                                </div>
                                                <div class="leyend-items">
                                                    <div class="value">555</div>
                                                    <div class="title">NEW</div>
                                                </div>
                                            </div>
                                            <div class="columns">
                                                <div class="totals">
                                                    <div class="totals-items">
                                                        <div class="value">333</div>
                                                        <div class="title">$61,739</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">41</div>
                                                        <div class="title">$2,229</div>
                                                    </div>
                                                </div>
                                                <div class="public">
                                                    <div class="totals-items">
                                                        <div class="value">324</div>
                                                        <div class="title">$60,996</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">36</div>
                                                        <div class="title">$1,659</div>
                                                    </div>
                                                </div>
                                                <div class="sharp">
                                                    <div class="totals-items">
                                                        <div class="value">9</div>
                                                        <div class="title">$741</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">5</div>
                                                        <div class="title">$570</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="section">
                                        <div class="header">
                                            <div class="title">
                                                SPREAD
                                            </div>
                                            <div class="totals">
                                                Totals
                                            </div>
                                            <div class="public">
                                                Public
                                            </div>
                                            <div class="sharp">
                                                Sharp
                                            </div>
                                        </div>
                                        <div class="data">
                                            <div class="leyend">
                                                <div class="leyend-items">
                                                    <div class="value">555</div>
                                                    <div class="title">DAL</div>
                                                </div>
                                                <div class="leyend-items">
                                                    <div class="value">555</div>
                                                    <div class="title">NEW</div>
                                                </div>
                                            </div>
                                            <div class="columns">
                                                <div class="totals">
                                                    <div class="totals-items">
                                                        <div class="value">333</div>
                                                        <div class="title">$61,739</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">41</div>
                                                        <div class="title">$2,229</div>
                                                    </div>
                                                </div>
                                                <div class="public">
                                                    <div class="totals-items">
                                                        <div class="value">324</div>
                                                        <div class="title">$60,996</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">36</div>
                                                        <div class="title">$1,659</div>
                                                    </div>
                                                </div>
                                                <div class="sharp">
                                                    <div class="totals-items">
                                                        <div class="value">9</div>
                                                        <div class="title">$741</div>
                                                    </div>
                                                    <div class="totals-items">
                                                        <div class="value">5</div>
                                                        <div class="title">$570</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php if (!empty($pick['picks'])): ?>
                                    <div class="picks-available">
                                        <i class="fal fa-check"></i><span><?php echo $pick['picks']; ?></span>
                                    </div>
                                <?php endif ?>
                            </div>

                            <?php if (!empty($pick['link'])): ?>
                                <div class="pick-footer">
                                    <a href="<?php echo $pick['link']['url']; ?>" target="<?php echo (empty($pick['link']['target'])) ? '_self' : $pick['link']['target']; ?>"><?php echo $pick['link']['title']; ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
