<?php  
     global $rdgb;
    $block_styles = [];
    $block_name = BLOCK_RDG_SECONDARY_BANNER;
    $block_classes = [$block_name];
    $block_admin_cappers = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    // Variables
   $description = get_field('description');
   $background = get_field('background');
   $linkBtn = get_field('link_btn');
   $textBtn = get_field('text_btn');

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="secondary-banner-container">
            <div class="left">
                <?php echo $description; ?>
            </div>
            <div class="right" style="background-image: url('<?php echo $background['url']; ?>');">
                <a href="<?php echo $linkBtn; ?>" class="btn"><?php echo $textBtn; ?></a>
            </div>
        </div>
    </div>
</div>
