<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_BEST_PPH_SITES];
    $block_best_pph_sites = $rdgb->settings->get_block(BLOCK_RDG_BEST_PPH_SITES);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $title = (get_field('sidebar_title') !== null && !empty(get_field('sidebar_title'))) ? get_field('sidebar_title') : null;
    $icon = (get_field('sidebar_icon') !== null && !empty(get_field('sidebar_icon'))) ? get_field('sidebar_icon') : null;
    $heading = (get_field('sidebar_heading') !== null && !empty(get_field('sidebar_heading'))) ? get_field('sidebar_heading') : 'span';
    $pphs = (is_array(get_field('pay_per_head_sites')) && count(get_field('pay_per_head_sites')) > 0) ? get_field('pay_per_head_sites') : [];
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php if (!empty($title) && !empty($heading)): ?>
                <<?php echo $heading; ?> class="sidebar-title">
                    <?php if (!empty($icon)): ?>
                        <span class="dashicons <?php echo $icon; ?>"></span>
                    <?php endif; ?>
                <?php echo $title; ?></<?php echo $heading; ?>>
            <?php endif; ?>

            <?php if (count($pphs) > 0): ?>
                <div class="sidebar-pphs">
                    <?php foreach ($pphs as $pph): ?>
                        <div class="sidebar-pph">
                            <?php if (isset($pph['logo']) && !empty($pph['logo'])): ?>
                                <span class="sidebar-image">
                                    <img src="<?php echo $pph['logo']['url']; ?>" alt="">
                                </span>
                            <?php endif; ?>

                            <?php if (isset($pph['description']) && !empty($pph['description'])): ?>
                                <span class="sidebar-description">
                                    <?php echo $pph['description']; ?>
                                </span>
                            <?php endif; ?>

                            <?php if (is_array($pph['link']) && isset($pph['link']['title']) && isset($pph['link']['url'])): ?>
                                <span class="sidebar-link">
                                    <?php
                                        $target = isset($pph['link']['target']) ? $pph['link']['target'] : '_self';
                                    ?>
                                    <a href="<?php echo $pph['link']['url']; ?>" target="<?php echo $target; ?>"><?php echo $pph['link']['title']; ?></a>
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
