<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Sport_Information extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_SPORT_INFORMATION;
    private $block_folder_name = 'rdg-sport-information';
    private $block_title = 'RDG Sport Information';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'banner', 'secondary', 'secondary banner'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_sport_information.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields() {
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group( array(
                'key' => 'group_65651df33b4c1',
                'title' => 'RDG Sport Information',
                'fields' => array(
                    array(
                        'key' => 'field_656750a758964',
                        'label' => 'Block Title',
                        'name' => 'block_title',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_65674e2d0ad6e',
                        'label' => 'Post Block',
                        'name' => 'post_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_65674e9f0ad6f',
                                'label' => 'Show Block',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => '',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_6568ab1b41bbc',
                                'label' => 'Show',
                                'name' => 'show',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'latest' => 'Latest Post',
                                    'specific' => 'Specific Post',
                                    'manual' => 'Manual Post',
                                ),
                                'default_value' => 'manual',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                            array(
                                'key' => 'field_65677e15dc3ed',
                                'label' => 'Specific Post',
                                'name' => 'specific_post',
                                'aria-label' => '',
                                'type' => 'relationship',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6568ab1b41bbc',
                                            'operator' => '==',
                                            'value' => 'specific',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'post_type' => array(
                                    0 => 'post',
                                ),
                                'post_status' => array(
                                    0 => 'publish',
                                ),
                                'taxonomy' => '',
                                'filters' => array(
                                    0 => 'search',
                                    1 => 'taxonomy',
                                ),
                                'return_format' => 'object',
                                'min' => 1,
                                'max' => 1,
                                'elements' => '',
                            ),
                            array(
                                'key' => 'field_656f2d3405a2c',
                                'label' => 'Specific Link',
                                'name' => 'specific_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6568ab1b41bbc',
                                            'operator' => '==',
                                            'value' => 'specific',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_6568ab7c8ab90',
                                'label' => 'Manual Post',
                                'name' => 'manual_post',
                                'aria-label' => '',
                                'type' => 'group',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6568ab1b41bbc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_6568ab958ab91',
                                        'label' => 'Featured Image',
                                        'name' => 'featured_image',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                    ),
                                    array(
                                        'key' => 'field_6568adf48ab92',
                                        'label' => 'Post Title',
                                        'name' => 'post_title',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                    ),
                                    array(
                                        'key' => 'field_6568adfe8ab93',
                                        'label' => 'Post Excerpt',
                                        'name' => 'post_excerpt',
                                        'aria-label' => '',
                                        'type' => 'wysiwyg',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'tabs' => 'all',
                                        'toolbar' => 'full',
                                        'media_upload' => 1,
                                        'delay' => 0,
                                    ),
                                    array(
                                        'key' => 'field_6568ae0c8ab94',
                                        'label' => 'Post Link',
                                        'name' => 'post_link',
                                        'aria-label' => '',
                                        'type' => 'link',
                                        'instructions' => '',
                                        'required' => 1,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                    ),
                                ),
                            ),
                            array(
                                'key' => 'field_656c848df397a',
                                'label' => 'Latest Post',
                                'name' => 'latest_post',
                                'aria-label' => '',
                                'type' => 'select',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6568ab1b41bbc',
                                            'operator' => '==',
                                            'value' => 'latest',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'alabama-crimson-tide' => '- Alabama Crimson Tide',
                                    'american-league' => '- American League',
                                    'anaheim-ducks' => '- Anaheim Ducks',
                                    'arizona-cardinals' => '- Arizona Cardinals',
                                    'arizona-coyotes' => '- Arizona Coyotes',
                                    'arizona-diamondbacks' => '- Arizona Diamondbacks',
                                    'arizona-wildcats' => '- Arizona Wildcats',
                                    'arkansas-razorbacks' => '- Arkansas Razorbacks',
                                    'arkansas-st-red-wolves' => '- Arkansas St. Red Wolves',
                                    'atlanta-braves' => '- Atlanta Braves',
                                    'atlanta-dream' => '- Atlanta Dream',
                                    'atlanta-falcons' => '- Atlanta Falcons',
                                    'atlanta-faze' => '- Atlanta FaZe',
                                    'atlanta-hawks' => '- Atlanta Hawks',
                                    'atlanta-reign' => '- Atlanta Reign',
                                    'atlanta-united-fc' => '- Atlanta United FC',
                                    'auburn-tigers' => '- Auburn Tigers',
                                    'austin-fc' => '- Austin FC',
                                    'auto-racing' => 'Auto Racing',
                                    'baltimore-orioles' => '- Baltimore Orioles',
                                    'baltimore-ravens' => '- Baltimore Ravens',
                                    'baseball' => 'Baseball',
                                    'basketball' => 'Basketball',
                                    'baylor-bears' => '- Baylor Bears',
                                    'boston-bruins' => '- Boston Bruins',
                                    'boston-celtics' => '- Boston Celtics',
                                    'boston-red-sox' => '- Boston Red Sox',
                                    'boston-uprising' => '- Boston Uprising',
                                    'brooklyn-nets' => '- Brooklyn Nets',
                                    'buffalo-bills' => '- Buffalo Bills',
                                    'buffalo-sabres' => '- Buffalo Sabres',
                                    'calgary-flames' => '- Calgary Flames',
                                    'callofduty' => '- CALLOFDUTY',
                                    'carolina-hurricanes' => '- Carolina Hurricanes',
                                    'carolina-panthers' => '- Carolina Panthers',
                                    'cf-montreal' => '- CF Montreal',
                                    'champ' => '- CHAMP',
                                    'charlotte-fc' => '- Charlotte FC',
                                    'charlotte-hornets' => '- Charlotte Hornets',
                                    'chengdu-hunters' => '- Chengdu Hunters',
                                    'chicago-bears' => '- Chicago Bears',
                                    'chicago-blackhawks' => '- Chicago Blackhawks',
                                    'chicago-bulls' => '- Chicago Bulls',
                                    'chicago-cubs' => '- Chicago Cubs',
                                    'chicago-fire' => '- Chicago Fire',
                                    'chicago-sky' => '- Chicago Sky',
                                    'chicago-white-sox' => '- Chicago White Sox',
                                    'cincinnati-bengals' => '- Cincinnati Bengals',
                                    'cincinnati-reds' => '- Cincinnati Reds',
                                    'clemson-tigers' => '- Clemson Tigers',
                                    'cleveland-browns' => '- Cleveland Browns',
                                    'cleveland-cavaliers' => '- Cleveland Cavaliers',
                                    'cleveland-guardians' => '- Cleveland Guardians',
                                    'colorado-avalanche' => '- Colorado Avalanche',
                                    'colorado-rapids' => '- Colorado Rapids',
                                    'colorado-rockies' => '- Colorado Rockies',
                                    'columbus-blue-jackets' => '- Columbus Blue Jackets',
                                    'columbus-crew-sc' => '- Columbus Crew SC',
                                    'concacaf' => '- CONCACAF',
                                    'connecticut-huskies' => '- Connecticut Huskies',
                                    'connecticut-sun' => '- Connecticut Sun',
                                    'creighton-bluejays' => '- Creighton Bluejays',
                                    'csgo' => '- CSGO',
                                    'd-c-united' => '- D.C. United',
                                    'dallas-cowboys' => '- Dallas Cowboys',
                                    'dallas-fuel' => '- Dallas Fuel',
                                    'dallas-mavericks' => '- Dallas Mavericks',
                                    'dallas-stars' => '- Dallas Stars',
                                    'dallas-wings' => '- Dallas Wings',
                                    'denver-broncos' => '- Denver Broncos',
                                    'denver-nuggets' => '- Denver Nuggets',
                                    'depaul-blue-demons' => '- DePaul Blue Demons',
                                    'detroit-lions' => '- Detroit Lions',
                                    'detroit-pistons' => '- Detroit Pistons',
                                    'detroit-red-wings' => '- Detroit Red Wings',
                                    'detroit-tigers' => '- Detroit Tigers',
                                    'dota' => '- DOTA',
                                    'drexel-dragons' => '- Drexel Dragons',
                                    'edmonton-oilers' => '- Edmonton Oilers',
                                    'esports' => 'eSports',
                                    'fc-cincinnati' => '- FC Cincinnati',
                                    'fc-dallas' => '- FC Dallas',
                                    'fighting' => 'Fighting',
                                    'florida-mayhem' => '- Florida Mayhem',
                                    'florida-mutineers' => '- Florida Mutineers',
                                    'florida-panthers' => '- Florida Panthers',
                                    'florida-state-seminoles' => '- Florida State Seminoles',
                                    'football' => 'Football',
                                    'george-washington-colonials' => '- George Washington Colonials',
                                    'georgetown-hoyas' => '- Georgetown Hoyas',
                                    'georgia-bulldogs' => '- Georgia Bulldogs',
                                    'golden-state-warriors' => '- Golden State Warriors',
                                    'golf' => 'Golf',
                                    'gonzaga-bulldogs' => '- Gonzaga Bulldogs',
                                    'green-bay-packers' => '- Green Bay Packers',
                                    'guangzhou-charge' => '- Guangzhou Charge',
                                    'hangzhou-spark' => '- Hangzhou Spark',
                                    'hockey' => 'Hockey',
                                    'houston-astros' => '- Houston Astros',
                                    'houston-cougars' => '- Houston Cougars',
                                    'houston-dash' => '- Houston Dash',
                                    'houston-dynamo' => '- Houston Dynamo',
                                    'houston-outlaws' => '- Houston Outlaws',
                                    'houston-rockets' => '- Houston Rockets',
                                    'houston-texans' => '- Houston Texans',
                                    'indiana-fever' => '- Indiana Fever',
                                    'indiana-hoosiers' => '- Indiana Hoosiers',
                                    'indiana-pacers' => '- Indiana Pacers',
                                    'indianapolis-colts' => '- Indianapolis Colts',
                                    'indy' => '- INDY',
                                    'inter-miami-cf' => '- Inter Miami CF',
                                    'iowa-hawkeyes' => '- Iowa Hawkeyes',
                                    'jacksonville-jaguars' => '- Jacksonville Jaguars',
                                    'kansas-city' => '- Kansas City',
                                    'kansas-city-chiefs' => '- Kansas City Chiefs',
                                    'kansas-city-royals' => '- Kansas City Royals',
                                    'kansas-jayhawks' => '- Kansas Jayhawks',
                                    'kentucky-wildcats' => '- Kentucky Wildcats',
                                    'las-vegas-aces' => '- Las Vegas Aces',
                                    'las-vegas-raiders' => '- Las Vegas Raiders',
                                    'london-royal-ravens' => '- London Royal Ravens',
                                    'los-angeles-angels' => '- Los Angeles Angels',
                                    'los-angeles-chargers' => '- Los Angeles Chargers',
                                    'los-angeles-clippers' => '- Los Angeles Clippers',
                                    'los-angeles-dodgers' => '- Los Angeles Dodgers',
                                    'los-angeles-fc' => '- Los Angeles FC',
                                    'los-angeles-galaxy' => '- Los Angeles Galaxy',
                                    'los-angeles-kings' => '- Los Angeles Kings',
                                    'los-angeles-lakers' => '- Los Angeles Lakers',
                                    'los-angeles-rams' => '- Los Angeles Rams',
                                    'los-angeles-sparks' => '- Los Angeles Sparks',
                                    'los-angeles-thieves' => '- Los Angeles Thieves',
                                    'louisiana-state-tigers' => '- Louisiana State Tigers',
                                    'marquette-golden-eagles' => '- Marquette Golden Eagles',
                                    'massachusetts-lowell-river-hawks' => '- Massachusetts Lowell River Hawks',
                                    'mcneese-st-mcneese' => '- McNeese St. McNeese',
                                    'memphis-grizzlies' => '- Memphis Grizzlies',
                                    'memphis-tigers' => '- Memphis Tigers',
                                    'miami-dolphins' => '- Miami Dolphins',
                                    'miami-heat' => '- Miami Heat',
                                    'miami-marlins' => '- Miami Marlins',
                                    'miami-florida-hurricanes' => '- Miami-Florida Hurricanes',
                                    'michigan-wolverines' => '- Michigan Wolverines',
                                    'milwaukee-brewers' => '- Milwaukee Brewers',
                                    'milwaukee-bucks' => '- Milwaukee Bucks',
                                    'minnesota-lynx' => '- Minnesota Lynx',
                                    'minnesota-timberwolves' => '- Minnesota Timberwolves',
                                    'minnesota-twins' => '- Minnesota Twins',
                                    'minnesota-united-fc' => '- Minnesota United FC',
                                    'minnesota-vikings' => '- Minnesota Vikings',
                                    'minnesota-wild' => '- Minnesota Wild',
                                    'mississippi-rebels' => '- Mississippi Rebels',
                                    'mississippi-state-bulldogs' => '- Mississippi State Bulldogs',
                                    'mlb' => '- MLB',
                                    'mls' => '- MLS',
                                    'montreal-canadiens' => '- Montreal Canadiens',
                                    'nas' => '- NAS',
                                    'nashville-predators' => '- Nashville Predators',
                                    'nashville-sc' => '- Nashville SC',
                                    'national-league' => '- National League',
                                    'nba' => '- NBA',
                                    'nba2k' => '- NBA2K',
                                    'nc-state-wolfpack' => '- NC State Wolfpack',
                                    'ncaab' => '- NCAAB',
                                    'new-england-patriots' => '- New England Patriots',
                                    'new-england-revolution' => '- New England Revolution',
                                    'new-jersey-devils' => '- New Jersey Devils',
                                    'new-mexico-lobos' => '- New Mexico Lobos',
                                    'new-mexico-st-aggies' => '- New Mexico St. Aggies',
                                    'new-orleans-pelicans' => '- New Orleans Pelicans',
                                    'new-orleans-saints' => '- New Orleans Saints',
                                    'new-york-city-fc' => '- New York City FC',
                                    'new-york-excelsior' => '- New York Excelsior',
                                    'new-york-giants' => '- New York Giants',
                                    'new-york-islanders' => '- New York Islanders',
                                    'new-york-jets' => '- New York Jets',
                                    'new-york-knicks' => '- New York Knicks',
                                    'new-york-liberty' => '- New York Liberty',
                                    'new-york-mets' => '- New York Mets',
                                    'new-york-rangers' => '- New York Rangers',
                                    'new-york-red-bulls' => '- New York Red Bulls',
                                    'new-york-subliners' => '- New York Subliners',
                                    'new-york-yankees' => '- New York Yankees',
                                    'nfl' => '- NFL',
                                    'nhl' => '- NHL',
                                    'niagara-purple-eagles' => '- Niagara Purple Eagles',
                                    'north-carolina-courage' => '- North Carolina Courage',
                                    'north-carolina-tar-heels' => '- North Carolina Tar Heels',
                                    'northwestern-wildcats' => '- Northwestern Wildcats',
                                    'nwsl' => '- NWSL',
                                    'oakland-athletics' => '- Oakland Athletics',
                                    'oklahoma-city-thunder' => '- Oklahoma City Thunder',
                                    'ol-reign' => '- OL Reign',
                                    'optic-texas' => '- OpTic Texas',
                                    'oregon-ducks' => '- Oregon Ducks',
                                    'orlando-city-sc' => '- Orlando City SC',
                                    'orlando-magic' => '- Orlando Magic',
                                    'ottawa-senators' => '- Ottawa Senators',
                                    'overwatch' => '- OVERWATCH',
                                    'pennsylvania-quakers' => '- Pennsylvania Quakers',
                                    'pga' => '- PGA',
                                    'philadelphia-76ers' => '- Philadelphia 76ers',
                                    'philadelphia-eagles' => '- Philadelphia Eagles',
                                    'philadelphia-flyers' => '- Philadelphia Flyers',
                                    'philadelphia-phillies' => '- Philadelphia Phillies',
                                    'philadelphia-union' => '- Philadelphia Union',
                                    'phoenix-mercury' => '- Phoenix Mercury',
                                    'phoenix-suns' => '- Phoenix Suns',
                                    'pittsburgh-penguins' => '- Pittsburgh Penguins',
                                    'pittsburgh-pirates' => '- Pittsburgh Pirates',
                                    'pittsburgh-steelers' => '- Pittsburgh Steelers',
                                    'portland-timbers' => '- Portland Timbers',
                                    'portland-trail-blazers' => '- Portland Trail Blazers',
                                    'purdue-boilermakers' => '- Purdue Boilermakers',
                                    'racing-louisville-fc' => '- Racing Louisville FC',
                                    'real-salt-lake' => '- Real Salt Lake',
                                    'rutgers-scarlet-knights' => '- Rutgers Scarlet Knights',
                                    'sacramento-kings' => '- Sacramento Kings',
                                    'san-antonio-spurs' => '- San Antonio Spurs',
                                    'san-diego' => '- San Diego',
                                    'san-diego-padres' => '- San Diego Padres',
                                    'san-diego-st-aztecs' => '- San Diego St. Aztecs',
                                    'san-francisco-49ers' => '- San Francisco 49ers',
                                    'san-francisco-giants' => '- San Francisco Giants',
                                    'san-francisco-shock' => '- San Francisco Shock',
                                    'san-jose-earthquakes' => '- San Jose Earthquakes',
                                    'san-jose-sharks' => '- San Jose Sharks',
                                    'seattle-kraken' => '- Seattle Kraken',
                                    'seattle-mariners' => '- Seattle Mariners',
                                    'seattle-seahawks' => '- Seattle Seahawks',
                                    'seattle-sounders-fc' => '- Seattle Sounders FC',
                                    'seattle-storm' => '- Seattle Storm',
                                    'seoul-infernal' => '- Seoul Infernal',
                                    'seton-hall-pirates' => '- Seton Hall Pirates',
                                    'soccer' => 'Soccer',
                                    'southern-california-trojans' => '- Southern California Trojans',
                                    'southern-miss-golden-eagles' => '- Southern Miss Golden Eagles',
                                    'sporting-kansas-city' => '- Sporting Kansas City',
                                    'sports' => 'Sports',
                                    'st-johns-red-storm' => '- St. John\'s Red Storm',
                                    'st-louis-blues' => '- St. Louis Blues',
                                    'st-louis-cardinals' => '- St. Louis Cardinals',
                                    'st-louis-city-sc' => '- St. Louis City SC',
                                    'syracuse-orange' => '- Syracuse Orange',
                                    'tampa-bay-buccaneers' => '- Tampa Bay Buccaneers',
                                    'tampa-bay-lightning' => '- Tampa Bay Lightning',
                                    'tampa-bay-rays' => '- Tampa Bay Rays',
                                    'tennessee-titans' => '- Tennessee Titans',
                                    'tennessee-volunteers' => '- Tennessee Volunteers',
                                    'texas-longhorns' => '- Texas Longhorns',
                                    'texas-rangers' => '- Texas Rangers',
                                    'texas-tech-red-raiders' => '- Texas Tech Red Raiders',
                                    'toronto-blue-jays' => '- Toronto Blue Jays',
                                    'toronto-defiant' => '- Toronto Defiant',
                                    'toronto-fc' => '- Toronto FC',
                                    'toronto-maple-leafs' => '- Toronto Maple Leafs',
                                    'toronto-raptors' => '- Toronto Raptors',
                                    'truck' => '- TRUCK',
                                    'uc-riverside-highlanders' => '- UC Riverside Highlanders',
                                    'ucla-bruins' => '- UCLA Bruins',
                                    'ufc' => '- UFC',
                                    'usa' => '- USA',
                                    'utah-jazz' => '- Utah Jazz',
                                    'vancouver-canucks' => '- Vancouver Canucks',
                                    'vancouver-whitecaps-fc' => '- Vancouver Whitecaps FC',
                                    'vanderbilt-commodores' => '- Vanderbilt Commodores',
                                    'vegas-golden-knights' => '- Vegas Golden Knights',
                                    'washington-capitals' => '- Washington Capitals',
                                    'washington-commanders' => '- Washington Commanders',
                                    'washington-huskies' => '- Washington Huskies',
                                    'washington-justice' => '- Washington Justice',
                                    'washington-mystics' => '- Washington Mystics',
                                    'washington-nationals' => '- Washington Nationals',
                                    'washington-spirit' => '- Washington Spirit',
                                    'washington-st-cougars' => '- Washington St. Cougars',
                                    'washington-wizards' => '- Washington Wizards',
                                    'west-virginia-mountaineers' => '- West Virginia Mountaineers',
                                    'winnipeg-jets' => '- Winnipeg Jets',
                                    'wnba' => '- WNBA',
                                    'xavier-musketeers' => '- Xavier Musketeers',
                                ),
                                'default_value' => 'NHL',
                                'return_format' => 'value',
                                'multiple' => 0,
                                'allow_null' => 0,
                                'ui' => 0,
                                'ajax' => 0,
                                'placeholder' => '',
                            ),
                            array(
                                'key' => 'field_656f2d1b1af9b',
                                'label' => 'Latest Link',
                                'name' => 'latest_link',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_6568ab1b41bbc',
                                            'operator' => '==',
                                            'value' => 'latest',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_65674ed50ad70',
                        'label' => 'Previews Block',
                        'name' => 'previews_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_65674ed50ad71',
                                'label' => 'Show Block',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => 'yes',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_656d1a33b3d89',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656d1a52b3d8a',
                                'label' => 'Vs List',
                                'name' => 'vs_list',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'table',
                                'pagination' => 0,
                                'min' => 1,
                                'max' => 3,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_656d1a7bb3d8b',
                                        'label' => 'Team A',
                                        'name' => 'team_a',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_656d1a52b3d8a',
                                    ),
                                    array(
                                        'key' => 'field_656d1a8ab3d8c',
                                        'label' => 'Team B',
                                        'name' => 'team_b',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_656d1a52b3d8a',
                                    ),
                                ),
                            ),
                            array(
                                'key' => 'field_656d1a97b3d8d',
                                'label' => 'Previews',
                                'name' => 'previews',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_656d1ac1b3d8e',
                                'label' => 'Recaps',
                                'name' => 'recaps',
                                'aria-label' => '',
                                'type' => 'link',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_65674ed60ad72',
                        'label' => 'Handicappers Block',
                        'name' => 'handicappers_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_65674ed60ad73',
                                'label' => 'Show Block',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => 'yes',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_656e0aae681ed',
                                'label' => 'Header Title',
                                'name' => 'header_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656cf6ffea85f',
                                'label' => 'Logo',
                                'name' => 'logo',
                                'aria-label' => '',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'return_format' => 'array',
                                'library' => 'all',
                                'min_width' => '',
                                'min_height' => '',
                                'min_size' => '',
                                'max_width' => '',
                                'max_height' => '',
                                'max_size' => '',
                                'mime_types' => '',
                                'preview_size' => 'medium',
                            ),
                            array(
                                'key' => 'field_656cf712ea860',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656cf796ea861',
                                'label' => 'Sub Title',
                                'name' => 'sub_title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656cf7a8ea862',
                                'label' => 'Total',
                                'name' => 'total',
                                'aria-label' => '',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'rows' => '',
                                'placeholder' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_656cf7c5ea863',
                                'label' => 'Picks',
                                'name' => 'picks',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656cf7d4ea864',
                                'label' => 'Picks Availables',
                                'name' => 'picks_availables',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_65674ed90ad74',
                        'label' => 'Picks Block',
                        'name' => 'picks_block',
                        'aria-label' => '',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_65674ed90ad75',
                                'label' => 'Show Block',
                                'name' => 'show_block',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'yes' => 'Yes',
                                    'no' => 'No',
                                ),
                                'default_value' => 'yes',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_656f739292cf5',
                                'label' => 'Title',
                                'name' => 'title',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656e113153afc',
                                'label' => 'Source',
                                'name' => 'source',
                                'aria-label' => '',
                                'type' => 'radio',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'choices' => array(
                                    'api' => 'API',
                                    'manual' => 'Manual',
                                ),
                                'default_value' => 'manual',
                                'return_format' => 'value',
                                'allow_null' => 0,
                                'other_choice' => 0,
                                'layout' => 'horizontal',
                                'save_other_choice' => 0,
                            ),
                            array(
                                'key' => 'field_656e115753afd',
                                'label' => 'Category',
                                'name' => 'category',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656e28c86a1a0',
                                'label' => 'Time',
                                'name' => 'time',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => 'YYYY-MM-DD HH:MM',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656e28d26a1a1',
                                'label' => 'Status',
                                'name' => 'status',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                            array(
                                'key' => 'field_656e29336a1a3',
                                'label' => 'Teams',
                                'name' => 'teams',
                                'aria-label' => '',
                                'type' => 'repeater',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'layout' => 'block',
                                'pagination' => 0,
                                'min' => 2,
                                'max' => 2,
                                'collapsed' => '',
                                'button_label' => 'Add Row',
                                'rows_per_page' => 20,
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_656e294f6a1a4',
                                        'label' => 'Logo',
                                        'name' => 'logo',
                                        'aria-label' => '',
                                        'type' => 'image',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'return_format' => 'array',
                                        'library' => 'all',
                                        'min_width' => '',
                                        'min_height' => '',
                                        'min_size' => '',
                                        'max_width' => '',
                                        'max_height' => '',
                                        'max_size' => '',
                                        'mime_types' => '',
                                        'preview_size' => 'medium',
                                        'parent_repeater' => 'field_656e29336a1a3',
                                    ),
                                    array(
                                        'key' => 'field_656e29636a1a5',
                                        'label' => 'Name',
                                        'name' => 'name',
                                        'aria-label' => '',
                                        'type' => 'text',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'default_value' => '',
                                        'maxlength' => '',
                                        'placeholder' => '',
                                        'prepend' => '',
                                        'append' => '',
                                        'parent_repeater' => 'field_656e29336a1a3',
                                    ),
                                ),
                            ),
                            array(
                                'key' => 'field_656e290f6a1a2',
                                'label' => 'Picks Availables',
                                'name' => 'picks_availables',
                                'aria-label' => '',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_656e113153afc',
                                            'operator' => '==',
                                            'value' => 'manual',
                                        ),
                                    ),
                                ),
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'maxlength' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_656750dc58965',
                        'label' => 'Block Footer',
                        'name' => 'block_footer',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/rdg-sport-information',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ) );
       
            endif;		
    }

    
}

add_filter('acf/load_field/name=latest_post', function($field) {
    $categories = get_categories();

    $choices = array();

    foreach ($categories as $category) {
        if ($category->category_parent == 0) {
            // Categoría principal (padre)
            $choices[$category->slug] = $category->name;
        } else {
            // Subcategoría (hijo)
            $parent_category = get_category($category->category_parent);
            $choices[$category->slug] = sprintf('- %s', $category->name);
        }
    }

    $field['choices'] = $choices;
    $field['default_value'] = 'NHL';
    return $field;
});

$rdg_sport_information_class = new Rdg_Blocks_Sport_Information ();
$rdg_sport_information_class->init();

return $rdg_secondary_banner_class;
