<?php  
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_name = BLOCK_RDG_MEMBERSHIP_INFO;
    $block_classes = [$block_name];

    $blockTitle = get_field('title');

    $premiumPackage = get_field('premium_package');
    $classicPackage = get_field('classic_package');
    $starterPlusPackage = get_field('starter_plus_package');
    $starterPackage = get_field('starter_package');
  
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>">
       <div class="mi_section">
            <div class="mi_wrapper">
                <?php if( $premiumPackage ): ?>
                <div class="mi_container">
                    <div class="mi_header">
                        <div class="mi_icon">
                        
                        <?php if (isset($premiumPackage['icon_img']) && is_array($premiumPackage['icon_img']) && !empty($premiumPackage['icon_img'])): ?>
                            <img src="<?php echo esc_url($premiumPackage['icon_img']['url']); ?>" alt="<?php echo esc_attr($premiumPackage['icon_img']['alt']); ?>">
                        <?php endif; ?>
                        </div>
                        <p><?php echo $premiumPackage['title']; ?></p>
                    </div>
                    <div class="mi_body">
                        <?php echo $premiumPackage['description']; ?>
                    </div>
                    <div class="mi_footer">
                        <div class="mi_picks"> 
                            <?php echo $premiumPackage['picks_availables']; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if( $classicPackage ): ?>
                <div class="mi_container">
                    <div class="mi_header">
                        <div class="mi_icon">
                        
                        <?php if (isset($classicPackage['icon_img']) && is_array($classicPackage['icon_img']) && !empty($classicPackage['icon_img'])): ?>
                            <img src="<?php echo esc_url($classicPackage['icon_img']['url']); ?>" alt="<?php echo esc_attr($classicPackage['icon_img']['alt']); ?>">
                        <?php endif; ?>
                        </div>
                        <p><?php echo $classicPackage['title']; ?></p>
                    </div>
                    <div class="mi_body">
                        <?php echo $classicPackage['description']; ?>
                    </div>
                    <div class="mi_footer">
                        <div class="mi_picks"> 
                            <?php echo $classicPackage['picks_availables']; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if( $starterPlusPackage ): ?>
                <div class="mi_container">
                    <div class="mi_header">
                        <div class="mi_icon">
                        
                        <?php if (isset($starterPlusPackage['icon_img']) && is_array($starterPlusPackage['icon_img']) && !empty($starterPlusPackage['icon_img'])): ?>
                            <img src="<?php echo esc_url($starterPlusPackage['icon_img']['url']); ?>" alt="<?php echo esc_attr($starterPlusPackage['icon_img']['alt']); ?>">
                        <?php endif; ?>
                        </div>
                        <p><?php echo $starterPlusPackage['title']; ?></p>
                    </div>
                    <div class="mi_body">
                        <?php echo $starterPlusPackage['description']; ?>
                    </div>
                    <div class="mi_footer">
                        <div class="mi_picks"> 
                            <?php echo $starterPlusPackage['picks_availables']; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if( $starterPackage ): ?>
                <div class="mi_container">
                    <div class="mi_header">
                        <div class="mi_icon">
                        
                        <?php if (isset($starterPackage['icon_img']) && is_array($starterPackage['icon_img']) && !empty($starterPackage['icon_img'])): ?>
                            <img src="<?php echo esc_url($starterPackage['icon_img']['url']); ?>" alt="<?php echo esc_attr($starterPackage['icon_img']['alt']); ?>">
                        <?php endif; ?>
                        </div>
                        <p><?php echo $starterPackage['title']; ?></p>
                    </div>
                    <div class="mi_body">
                        <?php echo $starterPackage['description']; ?>
                    </div>
                    <div class="mi_footer">
                        <div class="mi_picks"> 
                            <?php echo $starterPackage['picks_availables']; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
       </div>
    </div>
</div>
