<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_SPORTS_PICKS;
    $block_classes = [$block_name];
    $block_sports_picks = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $picks = get_field('picks');
    $links = get_field('links');
    $source = get_field('source');
    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $show = (!empty(get_field('show_in'))) ? get_field('show_in') : 'full';
    $link_options = (!empty(get_field('link_options'))) ? get_field('link_options') : 'none';
    $custom_link = (!empty(get_field('custom_link'))) ? get_field('custom_link') : null;

    $cache_file = null;
    $api_attributes = null;
    if ($source == 'api' && $block_sports_picks->is_caching()) {
        $api_url = get_field('sports_picks_api_url', 'option');
        $api_token = get_field('sports_picks_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;
        $sports = $rdgb->helpers->get_sporst_categories_titles();

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_sports_picks->get_api_attributes($items, ['category' => get_field('category')]);
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id_custom, $block_custom_id);
            $response = $block_sports_picks->get_resources($api_attributes, $cache_file);

            if (empty($response->message)) {
                $picks = $response->json;
            } else {
                $picks = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }
?>

<div class="rdg-blocks">
    <?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_sports_picks->get_log_debug($params);
    ?>
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?> <?php echo $show; ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

            <?php if (!empty($picks) && count($picks) > 0): ?>
                <div class="picks">
                    <?php if (!empty($picks)): ?>
                        <?php
                            if ($source == 'api') {
                                require 'partials/api.php';
                            } else {
                                require 'partials/manual.php';
                            }
                        ?>
                    <?php else: ?>
                        <?php if (!empty($message)): ?>
                            <span class="message"><?php echo $message; ?></span>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if (is_array($links) && count($links) > 0): ?>
                <div class="buttons">
                    <?php foreach($links as $link): ?>
                        <?php
                            $link_class = '';
                            $link_style = '';
                            if ($link['default_styles'] != 'custom') {
                                $link_class = 'class="'.$link['default_styles'].'"';
                            } else {
                                $link_style = 'onMouseOut="this.style.backgroundColor=\''.$link['background_color'].'\'" onmouseover="this.style.backgroundColor=\''.$link['background_hover_color'].'\'" class="link-default" style="'.$block_sports_picks->get_style('buttons', $link).'"';
                            }
                        ?>
                        <?php if (!empty($link['link']['url']) && $link['link']['title']): ?>
                            <a href="<?php echo $link['link']['url']; ?>" <?php echo $link_class; ?> <?php echo $link_style; ?>><?php echo $link['link']['title']; ?></a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
