<?php
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_name = BLOCK_RDG_TEAM_SCHEDULES;
    $block_classes = [$block_name];
    $block_team_schedules = $rdgb->settings->get_block($block_name);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $schedules = [];
    $titles = get_field('titles');
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $sport_team = (!empty(get_field('sports_teams'))) ? get_field('sports_teams') : null;
    $sport_season = (!empty(get_field('sports_seasons'))) ? get_field('sports_seasons') : null;


    $team_filter = $rdgb->helpers->get_filter($sport_team, $sport_season);
    $team_id = $block_team_schedules->get_team_id($team_filter);
    $team_name = $block_team_schedules->get_team_name($team_id);
    $template = explode('/', $team_filter['sport'])[2];
    //dump($team_filter);

    $placeholders = [
        '[team]' => $team_name,
        '[year]' => date('Y'),
    ];

    $pattern = '//';
    //dump(preg_match($pattern, $xx));

    $cache_file = null;
    $api_attributes = null;
    if ($block_team_schedules->is_caching()) {
        $api_url = get_field('team_schedules_api_url', 'option');
        $api_token = get_field('team_schedules_api_token', 'option');
        $items = (!empty(get_field('number_of_items'))) ? intval(get_field('number_of_items')) : 1;

        if (!empty($api_url) && !empty($api_token)) {
            $api_attributes = $block_team_schedules->get_api_attributes($items, ['filter' => $team_filter]);
            
            $block_custom_id = (!empty($block['data']['custom_id'])) ? $block['data']['custom_id'] : '';
            $post_id_custom = (!empty($block['data']['post_id'])) ? $block['data']['post_id'] : $post_id;
            $cache_file = $rdgb->helpers->get_cache_name($block_name, $post_id_custom, $block_custom_id);
            $response = $block_team_schedules->get_resources($api_attributes, $cache_file);
            
            if (empty($response->message) && isset($response->json[0]['data-content'][0][0]['games'])) {
                $schedules = $response->json[0]['data-content'][0][0]['games'];
            } else {
                $schedules = null;
                $message = $response->message;
            }
        } else {
            $message = __('Configure API connection correctly.');
        }
    }

    //dump($api_attributes);
?>

<div class="rdg-blocks">
    <?php
        $params = ['cache_file' => $cache_file, 'api_request' => $api_attributes];
        $block_team_schedules->get_log_debug($params);
    ?>
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <?php require RDGBLOCKS_PLUGIN_BLOCKS_DIR.'partials/titles.php'; ?>

        <?php if (is_array($schedules) && count ($schedules) > 0): ?>
            <div class="schedules">
                <table class="schedules-table">
                    <?php $partial_path = RDGBLOCKS_PLUGIN_BLOCKS_DIR.BLOCK_RDG_TEAM_SCHEDULES.'/partials/'; ?>
                    <?php if (file_exists($partial_path.$template.'.php')): ?>
                        <?php require $partial_path.$template.'.php'; ?>
                        <?php else: ?>
                        <?php require $partial_path.'default.php'; ?>
                    <?php endif; ?>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
