<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Promote_Site extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_PROMOTE_SITE;
    private $block_folder_name = BLOCK_RDG_PROMOTE_SITE;
    private $block_title = 'RDG Promote Site';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'promote', 'site'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_promote_site.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function register_fields() {
        add_action( 'acf/include_fields', function() {
            if ( ! function_exists( 'acf_add_local_field_group' ) ) {
                return;
            }
        
            acf_add_local_field_group( array(
            'key' => 'group_65c10dd11e3d7',
            'title' => 'Promote SIte',
            'fields' => array(
                array(
                    'key' => 'field_65c10dd143cfd',
                    'label' => 'Site Logo',
                    'name' => 'promote_site_logo',
                    'aria-label' => '',
                    'type' => 'image',
                    'instructions' => '',
                    'required' => 1,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '20',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'uploader' => '',
                    'return_format' => 'array',
                    'upload_folder' => '',
                    'acfe_thumbnail' => 0,
                    'required_message' => '',
                    'min_width' => '',
                    'min_height' => '',
                    'min_size' => '',
                    'max_width' => '',
                    'max_height' => '',
                    'max_size' => '',
                    'mime_types' => '',
                    'preview_size' => 'thumbnail',
                    'library' => 'all',
                ),
                array(
                    'key' => 'field_65c10ea539631',
                    'label' => 'Site Name',
                    'name' => 'promote_site_name',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 1,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '60',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'default_value' => '',
                    'required_message' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65c10f1cd0e4e',
                    'label' => 'Offer Amount',
                    'name' => 'promote_site_offer_amount',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 1,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '20',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'default_value' => '',
                    'required_message' => '',
                    'min' => '',
                    'max' => '',
                    'placeholder' => '',
                    'step' => '',
                    'prepend' => '$',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65c113460521b',
                    'label' => 'Offer Description',
                    'name' => 'promote_site_offer_description',
                    'aria-label' => '',
                    'type' => 'textarea',
                    'instructions' => '',
                    'required' => 1,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'default_value' => '',
                    'acfe_textarea_code' => 0,
                    'required_message' => '',
                    'maxlength' => '',
                    'rows' => 3,
                    'placeholder' => '',
                    'new_lines' => '',
                ),
                array(
                    'key' => 'field_65c1153ce587b',
                    'label' => 'Action button text',
                    'name' => 'promote_site_action_button_text',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 1,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '50',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'default_value' => '',
                    'required_message' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65c16110d51e7',
                    'label' => 'Age terms',
                    'name' => 'promote_site_age_terms',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '50',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'default_value' => '',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_65c15fb7ab295',
                    'label' => 'Offer Features',
                    'name' => 'promote_site_offer_features',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'acfe_save_meta' => 0,
                    'acfe_repeater_stylised_button' => 0,
                    'layout' => 'table',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_65c1605aab296',
                            'label' => 'Features',
                            'name' => 'promote_site_feature',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'acfe_save_meta' => 0,
                            'default_value' => '',
                            'required_message' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_65c15fb7ab295',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'acf-options-promote-site',
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
            'acfe_autosync' => '',
            'acfe_form' => 0,
            'acfe_display_title' => '',
            'acfe_meta' => '',
            'acfe_note' => '',
        ) );
        } );
                                   
    }
}

$rdg_promote_site_class = new Rdg_Blocks_Promote_Site();
$rdg_promote_site_class->init();

return $rdg_promote_site_class;