<div class="table-wrapper">
    <table class="sortable">
        <thead>
            <tr>
                <th class="w-1 static-column">#</th>
                <th class="w-2">Name</th>
                <th class="w-3">Total Bets</th>
                <th class="w-1">Win</th>
                <th class="w-1">Loss</th>
                <th class="w-1">Push</th>
                <th class="w-3">Win%</th>
                <th class="w-3">Win Amount</th>
                <th class="w-3">Risk Amount</th>
                <th class="w-3">Net</th>
            </tr>
        </thead>
        <tbody>
            <?php $fields = $block_leader_board->get_fields_validate(); ?>
            <?php foreach ($leaders as $key => $leader): ?>
                <?php if (!$rdgb->helpers->validate_fields($fields, $leader)) continue; ?>
                <?php if (!empty($leader['rank']) && !empty($leader['name'])): ?>
                    <tr>
                        <td class="w-1 static-column"><?php echo $leader['rank']; ?></td>
                        <td class="name w-2"><?php echo $leader['name']; ?></td>
                        <td class="w-3"><?php echo (!empty($leader['total_bets'])) ? $leader['total_bets'] : 0; ?></td>
                        <td class="w-1"><?php echo (!empty($leader['win'])) ? $leader['win'] : 0; ?></td>
                        <td class="w-1"><?php echo (!empty($leader['loss'])) ? $leader['loss'] : 0; ?></td>
                        <td class="w-1"><?php echo (!empty($leader['push'])) ? $leader['push'] : 0; ?></td>
                        <td class="w-1"><?php echo number_format($leader['win_percentaje'], 0, '.', ','); ?>%</td>
                        <td class="w-3">$<?php echo number_format($leader['win_amount'], 0, '.', ','); ?></td>
                        <td class="w-3">$<?php echo number_format($leader['risk_amount'], 0, '.', ','); ?></td>
                        <td class="w-3">$<?php echo number_format($leader['net'], 0, '.', ','); ?></td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; ?>
        </tbody>
        <tfoot class="list-pagination">
            <tr>
                <td colspan="100%">
                    <?php echo $rdgb->helpers->rdg_pagination($page, $total_pages); ?>
                </td>
            </tr>
        </tfoot>
    </table>
</div>





