<?php

namespace Rdgcorp\Blocks\TeamSchedules\Utils;

require __DIR__ . '/../MasterFeed/vendor/autoload.php';

use Rdgcorp\MasterFeed\MasterFeed;

class MasterFeedApiConsumer
{
    private MasterFeed $masterFeed;

    public function __construct(string $token)
    {
        $this->masterFeed = new MasterFeed($token);
    }

    public function getSports(): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectSports() as $sport) {
            $data[$sport['id']] = $sport['name'];
        }

        return $data;
    }

    public function getLeagues(?string $sportId = null): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectLeagues($sportId) as $league) {
            $data[$league['id']] = $league['name'];
        }

        return $data;
    }

    public function getTeams(?string $leagueId = null): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectTeams($leagueId) as $team) {
            $data[$team['id']] = $team['name'];
        }

        return $data;
    }

    public function getSeasons(?string $leagueId = null): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectSeasons($leagueId) as $season) {
            $data[$season['id']] = $season['name'];
        }

        return $data;
    }

    public function getSchedules(?string $teamId = null, ?string $seasonId = null): array
    {
        $teams = $this->getTeams();

        $dataByWeek = [];

        foreach ($this->masterFeed->getDirectSchedules($teamId, $seasonId) as $schedule) {
            if ($schedule['home_team_id'] === $teamId) {
                $opponent = $teams[$schedule['visitor_team_id']];

                $teamRol = 'home';
                $opponentRol = 'away';
            } else {
                $opponent = $teams[$schedule['home_team_id']];

                $teamRol = 'away';
                $opponentRol = 'home';
            }

            $stats = [];

            foreach ($schedule['stats'] as $stat) {
                $stats[strtolower($stat['side'])] = (string)$stat['value'];
            }

            if (1 === count($stats)) {
                if (!isset($stats['home'])) {
                    $stats['home'] = 0;
                }

                if (!isset($stats['away'])) {
                    $stats['away'] = 0;
                }
            }

            if (2 == count($stats)) {
                if ($stats[$teamRol] === $stats[$opponentRol]) {
                    $result = 'T ' . $stats[$teamRol] . '-' . $stats[$opponentRol];
                } elseif ($stats[$teamRol] > $stats[$opponentRol]) {
                    $result = 'W ' . $stats[$teamRol] . '-' . $stats[$opponentRol];
                } else {
                    $result = 'L ' . $stats[$teamRol] . '-' . $stats[$opponentRol];
                }
            } else {
                $result = 'TBD';
            }

            $date = new \DateTime($schedule['start_date']);

            $dataByWeek[(int)$date->format('W')][] = [
                'date' => $date->format('D m/d'),
                'opponent' => $opponent,
                'result' => $result,
            ];
        }

        $data = [];

        $currentSeasonWeek = 1;
        $currentRealWeek = array_key_first($dataByWeek);

        while (0 < count($dataByWeek)) {
            if (isset($dataByWeek[$currentRealWeek])) {
                foreach ($dataByWeek[$currentRealWeek] as $schedule) {
                    $schedule['week'] = 'Week ' . $currentSeasonWeek;
                    $data[] = $schedule;
                }

                unset($dataByWeek[$currentRealWeek]);
            } else {
                $data[] = [
                    'week' => 'Week ' . $currentSeasonWeek,
                    'date' => 'BYE',
                    'opponent' => 'BYE',
                    'result' => 'BYE',
                ];
            }

            if (52 === (int)$currentRealWeek) {
                $currentRealWeek = 0;
            }

            $currentRealWeek++;
            $currentSeasonWeek++;
        }

        return $data;
    }
}
