<?php

namespace Rdgcorp\Blocks\TeamSchedules\Utils;

require __DIR__ . '/../MasterFeed/vendor/autoload.php';
require __DIR__ . '/mappers/SchedulesMapperInterface.php';
require __DIR__ . '/mappers/AbstractScheduleMapper.php';
require __DIR__ . '/mappers/FootballSchedulesMapper.php';
require __DIR__ . '/mappers/BaseballSchedulesMapper.php';

use Rdgcorp\Blocks\TeamSchedules\Utils\Mappers\BaseballSchedulesMapper;
use Rdgcorp\Blocks\TeamSchedules\Utils\Mappers\FootballSchedulesMapper;
use Rdgcorp\Blocks\TeamSchedules\Utils\Mappers\SchedulesMapperInterface;
use Rdgcorp\MasterFeed\MasterFeed;

class MasterFeedApiConsumer
{
    private MasterFeed $masterFeed;

    public function __construct(string $token)
    {
        $this->masterFeed = new MasterFeed($token);
    }

    public function getSports(): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectSports() as $sport) {
            $data[$sport['id']] = $sport['name'];
        }

        return $data;
    }

    public function getLeagues(?string $sportId = null): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectLeagues($sportId) as $league) {
            $data[$league['id']] = $league['name'];
        }

        return $data;
    }

    public function getTeams(?string $leagueId = null): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectTeams($leagueId) as $team) {
            $data[$team['id']] = $team['name'];

            if (!ctype_upper($team['nickname']) && !str_contains(strtolower($team['name']), strtolower($team['nickname']))) {
                $data[$team['id']] .= ' ' . $team['nickname'];
            }
        }

        return $data;
    }

    public function getSeasons(?string $leagueId = null): array
    {
        $data = [];

        foreach ($this->masterFeed->getDirectSeasons($leagueId) as $season) {
            $data[$season['id']] = $season['name'];
        }

        return $data;
    }

    public function getSchedules(?string $teamId = null, ?string $seasonId = null): ?array
    {
        $mapperClass = $this->getMapper($teamId);

        if (!$mapperClass) {
            return null;
        }

        $teams = $this->getTeams();
        $rawSchedules = $this->masterFeed->getDirectSchedules($teamId, $seasonId);

        /** @var SchedulesMapperInterface $mapper */
        $mapper = new $mapperClass($teams);

        return $mapper->getMappedData($teamId, $rawSchedules);
    }

    public function hasMapper(string $teamId): bool
    {
        if ($this->getMapper($teamId)) {
            return true;
        }

        return false;
    }

    private function getMapper(string $teamId): ?string
    {
        $data = explode('/', $teamId);

        switch ($data[2]) {
            case 'football':
                return FootballSchedulesMapper::class;
            case 'baseball':
                return BaseballSchedulesMapper::class;
            default:
                return null;
        }
    }
}
