<?php

add_action('acf/init', function () {
    if (function_exists('acf_register_block_type')) {
        $manifest = file_get_contents(__DIR__ . '/../../dist/manifest.json');
        $assets = json_decode($manifest, true);

        acf_register_block_type([
            'name' => 'rdg-top-sites',
            'title' => __('RDG Top Sites'),
            'description' => __('List of top sites'),
            'category' => RDGBLOCKS_NAME_SLUG,
            'icon' => 'admin-links',
            'keywords' => ['rdg', 'custom', 'top', 'sites'],
            'render_template' => __DIR__ . '/template.php',
            'enqueue_style' => plugin_dir_url(__DIR__ . '/../../../') . 'dist/' . $assets['rdg_top_sites.css'],
            'mode' => 'preview',
        ]);
    }
}, 20);

add_action('acf/init', function () {
    if (function_exists('acf_add_local_field_group')) {
        $json = file_get_contents(__DIR__ . '/fields/block_fields.json');

        acf_add_local_field_group(json_decode($json, true));
    }
}, 20);
