<?php

$block = get_field('block');

?>

<div class="rdg-blocks">
    <div class="rdg-top-sites">
        <?php if ($block): ?>
            <div class="rdg-top-sites-card">
                <div class="card-header">
                    <h5><?php echo $block['header']['title'] ?></h5>
                </div>
                <div class="card-content">
                    <table>
                        <?php foreach ($block['content']['items'] as $item): ?>
                            <tr>
                                <td>
                                    <?php if ($item['image']): ?>
                                        <img src="<?php echo $item['image']['url'] ?>"
                                             alt="<?php echo $item['image']['alt'] ?>">
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $item['description'] ?></td>
                                <td>
                                    <?php if ($item['link']): ?>
                                        <a href="<?php echo $item['link']['url'] ?>"
                                           target="<?php echo $item['link']['target'] ?>">
                                            <?php echo $item['link']['title'] ?>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <div class="card-footer">
                    <?php if ($block['footer']['button'] && $block['footer']['link']): ?>
                        <a href="<?php echo $block['footer']['link']['url'] ?>"
                           target="<?php echo $block['footer']['link']['target'] ?>">
                            <?php echo $block['footer']['link']['title'] ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <p>Please, complete the form.</p>
        <?php endif; ?>
    </div>
</div>
