<?php

$error = null;

try {
    if (!isset($teamSchedulesBlockDataLoader)) {
        $teamSchedulesBlockDataLoader = new \Rdgcorp\Blocks\TeamSchedules\BlockDataLoader();
    }

    $teamId = get_field('team');
    $seasonId = get_field('season');

    $schedulesByType = ($teamId && $seasonId) ? $teamSchedulesBlockDataLoader->getSchedules($teamId, $seasonId) : null;
} catch (\Throwable $exception) {
    $error = $exception->getMessage();
}

?>

<div class="rdg-blocks">
    <div class="rdg-team-schedules">
        <?php if ($error && is_user_logged_in() && current_user_can('administrator')): ?>
            <h2>Fatal Error:</h2>
            <pre><?php echo $error; ?></pre>
        <?php elseif (is_array($schedulesByType) && count($schedulesByType)): ?>
            <?php foreach ($schedulesByType as $key => $schedules): ?>
                <h2><?php echo str_replace('-', ' ', $key); ?></h2>
                <table>
                    <thead>
                    <tr>
                        <th>Week</th>
                        <th>Date</th>
                        <th>Opponent</th>
                        <th>Result</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($schedules as $schedule): ?>
                        <tr>
                            <td>
                                <?php echo $schedule['type']; ?>
                            </td>
                            <td>
                                <span>Date:</span>
                                <?php echo $schedule['date']; ?>
                            </td>
                            <td>
                                <span>Opponent:</span>
                                <?php echo $schedule['opponent']; ?>
                            </td>
                            <td>
                                <span>Result:</span>
                                <?php echo $schedule['result']; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endforeach; ?>
        <?php elseif (!$teamId || !$seasonId): ?>
            <p>Please complete the block form.</p>
        <?php elseif (null === $schedulesByType): ?>
            <p>The selected sport does not have a schedule mapper configured.</p>
        <?php elseif (is_array($schedulesByType)): ?>
            <p>No schedules found.</p>
        <?php else: ?>
            <p>Error.</p>
        <?php endif; ?>
    </div>
</div>

<?php
if ('active' === get_field('rdg_blocks_debug_cache', 'options') || 'active' === get_field('rdg_blocks_debug_request', 'options')) {
    if (is_user_logged_in() && current_user_can('administrator')) {
        if ($teamId && $seasonId) {
            $apiUrl = 'http://masterfeed.shnadmin.com/feed/sportdirect/schedules?key=' . $teamSchedulesBlockDataLoader->getApiKey() . '&team_id=' . $teamId . '&season_id=' . $seasonId;
            $log = json_encode($teamSchedulesBlockDataLoader->getLastSchedulesLog(), JSON_PRETTY_PRINT);
        } else {
            $apiUrl = 'null';
            $log = 'The block requires more data, go to edit mode and complete the form.';
        }

        echo "<!--\n";
        echo "==================================================================================================================\n";
        echo "--------------------------------------------Debug Team schedules block--------------------------------------------\n";
        echo "==================================================================================================================\n";
        echo "---------------------------------------------API URL (Only Reference)---------------------------------------------\n";
        echo "==================================================================================================================\n";
        echo $apiUrl . "\n";
        echo "==================================================================================================================\n";
        echo "-------------------------------------------------------Logs-------------------------------------------------------\n";
        echo "==================================================================================================================\n";
        echo $log . "\n";
        echo "==================================================================================================================\n";
        echo "-->";
    }
}
?>
