<?php 
    global $rdgb;
    $rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

    $block_styles = [];
    $block_classes = [BLOCK_RDG_GAMBLING_CENTER];
    $block_gambling_center = $rdgb->settings->get_block(BLOCK_RDG_GAMBLING_CENTER);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $fields_cpt = $block_gambling_center->get_fields_cpt(get_fields());
    $data = $block_gambling_center->get_elements_type($fields_cpt);
    $cpt_active = $block_gambling_center->is_valid_cpt($fields_cpt['cpt']);

    if ($data instanceof WP_Query) {
        $posts = $data->posts;
    } else {
        $posts = $data;
    }
    
    $position_block = $rdgb->helpers->get_blocks_spaces(get_fields());
    $title = (get_field('gambling_center_title') !== null && !empty(get_field('gambling_center_title'))) ? get_field('gambling_center_title') : null;
    $icon = (get_field('gambling_center_ico') !== null && !empty(get_field('gambling_center_ico'))) ? get_field('gambling_center_ico') : null;
    $heading = (get_field('gambling_center_heading') !== null && !empty(get_field('gambling_center_heading'))) ? get_field('gambling_center_heading') : 'span';
?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="content">
            <?php if ($cpt_active): ?>
                <?php if (!empty($title) && !empty($heading)): ?>
                    <<?php echo $heading; ?> class="title">
                        <?php if (!empty($icon)): ?>
                            <span class="dashicons <?php echo $icon; ?>"></span>
                        <?php endif; ?>
                    <?php echo $title; ?></<?php echo $heading; ?>>
                <?php endif; ?>

                <?php if (is_array($posts) && count($posts) > 0): ?>
                    <main class="posts">
                        <?php foreach($posts as $post): ?>
                            <article id="post-<?php the_ID(); ?>">
                                <a href="<?php echo get_post_permalink($post->ID); ?>">
                                    <span>
                                        <?php echo $post->post_title; ?>
                                    </span>
                                </a>
                            </article>
                        <?php endforeach; ?>
                    </main>
                <?php endif; ?>
            <?php else: ?>
                <div class="message danger">
                    <?php
                        $cpt = (is_array($fields_cpt['cpt'])) ? implode(', ', $fields_cpt['cpt']) : $fields_cpt['cpt'];
                    ?>
                    <span><?php echo __('CPT '.$cpt.' does not exist.'); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
