<?php $fields = $block_sports_picks_vs->get_fields_validate(); ?>
<?php foreach($picks as $pick):?>
    <?php if (!$rdgb->helpers->validate_fields($fields, $pick)) continue; ?>
    <div class="pick">
        <div class="pick-header">
            <div class="title">
                <span class="header-title"><?php echo $pick['home_team']; ?> vs <?php echo $pick['visitor_team']; ?></span>
            </div>
        </div>
        <div class="pick-body">
            <div class="teams">
                <div class="team team-a">
                    <div class="team-logo">
                        <?php
                            $pick_image = $block_sports_picks_vs->get_image($pick['home_image'], [
                                'image_type' => 'sport_pick_vs',
                                'image_alt' => $pick['home_team'],
                                'logo_label' => true,
                            ]);
                        ?>
                        <?php if (isset($pick['home_image']) && $pick['home_image'] != ''): ?>
                            <img src="<?php echo $pick_image['url']; ?>" alt="<?php echo $pick_image['alt']; ?>">
                        <?php endif; ?>
                    </div>
                </div>

                <div class="team team-vs">
                    <div class="vs-logo"><span>vs</span></div>
                </div>

                <div class="team team-b">
                    <div class="team-logo">
                        <?php
                            $pick_image_visitor = $block_sports_picks_vs->get_image($pick['visitor_image'], [
                                'image_type' => 'sport_pick_vs',
                                'image_alt' => $pick['visitor_team'],
                                'logo_label' => true,
                            ]);
                        ?>
                        <?php if (isset($pick['visitor_image']) && $pick['visitor_image'] != ''): ?>
                            <img src="<?php echo $pick_image_visitor['url']; ?>" alt="<?php echo $pick_image_visitor['alt']; ?>">
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="fields">
                <div class="field separator">
                    <div class="team-home"><?php echo $pick['home_team']; ?></div>
                    <div class="leyend"><?php echo _('ODDS'); ?></div>
                    <div class="team-visitor"><?php echo $pick['visitor_team']; ?></div>
                </div>

                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick['opener_game_odds'][0]['spread_home_odds'])) ? $pick['opener_game_odds'][0]['spread_home_odds'] : '-'; ?></div>
                    <div class="leyend"><?php echo _('OPENER'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick['opener_game_odds'][0]['spread_visitor_odds'])) ? $pick['opener_game_odds'][0]['spread_visitor_odds'] : '-'; ?></div>
                </div>

                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick['current_game_odds'][0]['spread_home_odds'])) ? $pick['current_game_odds'][0]['spread_home_odds'] : '-'; ?></div>
                    <div class="leyend"><?php echo _('CURRENT'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick['current_game_odds'][0]['spread_visitor_odds'])) ? $pick['current_game_odds'][0]['spread_visitor_odds'] : '-'; ?></div>
                </div>
            
                <div class="field separator">
                    <div class="team-home"><?php echo (!empty($pick['current_game_odds'][0]['money_line_home_odds'])) ? $pick['current_game_odds'][0]['money_line_home_odds'] : '-'; ?></div>
                    <div class="leyend"><?php echo _('MONEYLINE'); ?></div>
                    <div class="team-visitor"><?php echo (!empty($pick['current_game_odds'][0]['money_line_visitor_odds'])) ? $pick['current_game_odds'][0]['money_line_visitor_odds'] : '-'; ?></div>
                </div>
            </div>

            <?php if (!empty($pick['game_picks_count']) && intval($pick['game_picks_count']) > 0): ?>
                <div class="picks-available">
                    <?php if ($link_options != 'none'): ?>
                        <?php
                            $url = '';
                            $target = '_self';

                            if ($link_options == 'custom') {
                                if (is_array($custom_link)) {
                                    if (isset($custom_link['url'])) {
                                        $url = $custom_link['url'];
                                    }
    
                                    if (isset($custom_link['target']) && !empty($custom_link['target'])) {
                                        $target = $custom_link['target'];
                                    }
                                }
                            } else {
                                $url = (!empty($pick['game_url'])) ? $pick['game_url'] : '#';
                                $target = '_blank';
                            }
                        ?>
                        <a href="<?php echo $url; ?>" target="<?php echo $target; ?>" rel="noopener nofollow">
                    <?php endif; ?>
                        <span>
                            <?php
                                $link_title = $pick['game_picks_count'].' PICKS AVAILABLE';
                                if ($link_options == 'custom') {
                                    $link_title = (!empty($custom_link['title'])) ? $custom_link['title'] : $pick['game_picks_count'].' PICKS AVAILABLE';
                                }
                            ?>
                            <?php echo $link_title; ?>
                        </span>
                    <?php if ($link_options != 'none'): ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif ?>
        </div>

        <div class="pick-footer">
            <?php if (!empty($all_link)): ?>
                <a href="<?php echo $all_link['url']; ?>" target="<?php echo (empty($all_link['target'])) ? '_self' : $all_link['target']; ?>"><?php echo $all_link['title']; ?></a>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>
