<?php

global $rdgb;

$rdgb = (!empty($rdgb)) ? $rdgb : Rdg_Blocks::instance();

$block_styles = [];
$block_classes = ['rdg-top-sites'];
$block_top_sites = $rdgb->settings->get_block(BLOCK_RDG_TOP_SITES);

if (!empty($block['backgroundColor'])) {
    $block_classes[] = 'has-background';
    $block_classes[] = 'has-' . $block['backgroundColor'] . '-background-color';
}

if (!empty($block['style']['color']['background'])) {
    $block_styles[] = 'background-color: ' . $block['style']['color']['background'] . ';';
}

$titles = get_field('titles');
$position_block = $rdgb->helpers->get_blocks_spaces(get_fields());

$data = $block_top_sites->get_data();

?>

<div class="rdg-blocks">
    <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>"
         style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
        <div class="container content grid-container">
            <?php if ($data): ?>
                <div class="rdg-top-sites-card">
                    <div class="card-header">
                        <h5><?php echo $data['header']['title'] ?></h5>
                    </div>
                    <div class="card-content">
                        <table>
                            <?php foreach ($data['content']['items'] as $item): ?>
                                <tr>
                                    <td>
                                        <?php if ($item['image']): ?>
                                            <img src="<?php echo $item['image']['url'] ?>"
                                                 alt="<?php echo $item['image']['alt'] ?>">
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $item['description'] ?></td>
                                    <td>
                                        <?php if ($item['link']): ?>
                                            <a href="<?php echo $item['link']['url'] ?>"
                                               target="<?php echo $item['link']['target'] ?>">
                                                <?php echo $item['link']['title'] ?>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </table>
                    </div>
                    <div class="card-footer">
                        <?php if ($data['footer']['button']): ?>
                            <a href="<?php echo $data['footer']['link']['url'] ?>"
                               target="<?php echo $data['footer']['link']['target'] ?>">
                                <?php echo $data['footer']['link']['title'] ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php else: ?>
                <p>Please, complete the form.</p>
            <?php endif; ?>
        </div>
    </div>
</div>
