<?php

if (!defined('ABSPATH')) {
    exit;
}

class Rdg_Blocks_Top_Sites extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_TOP_SITES;
    private $block_folder_name = 'rdg-top-sites';
    private $block_title = 'RDG Top Sites';
    private $block_description = 'List of top sites';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'top', 'sites'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;

    protected $is_caching = false;

    protected $is_config = false;

    protected $is_styles_load = true;

    public function init()
    {
        $this->register_block();
        $this->register_fields();
    }

    private function register_block(): void
    {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/" . $this->block_folder_name . "/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_top_sites.css'),
                'supports' => [
                    'jsx' => true,
                    'color' => [
                        'background' => true,
                        'gradients' => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    private function register_fields(): void
    {
        if (function_exists('acf_add_local_field_group')) {
            $json = file_get_contents(__DIR__ . '/fields/block_fields.json');

            acf_add_local_field_group(json_decode($json, true));
        }
    }

    public function get_data(): array
    {
        $data = [];

        if (get_field('title')) {
            $data['title'] = get_field('title');
        }

        if (get_field('items')) {
            $data['items'] = get_field('items');
        }

        if (get_field('button')) {
            $data['button'] = get_field('button');
        }

        if (get_field('link')) {
            $data['link'] = get_field('link');
        }

        return $data;
    }

    public function getColorsToloadGeneratePress()
    {
        return [
            [
                'name' => 'color-top-sites-box-shadow-1',
                'slug' => 'color-top-sites-box-shadow-1',
                'color' => 'rgba(255, 255, 255, 0.15)'
            ],
            [
                'name' => 'color-top-sites-box-shadow-2',
                'slug' => 'color-top-sites-box-shadow-2',
                'color' => 'rgba(0, 0, 0, 0.075)'
            ],
            [
                'name' => 'color-top-sites-card-bg',
                'slug' => 'color-top-sites-card-bg',
                'color' => '#f2f2f2'
            ],
            [
                'name' => 'color-top-sites-card-header',
                'slug' => 'color-top-sites-card-header',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-top-sites-card-header-bg',
                'slug' => 'color-top-sites-card-header-bg',
                'color' => '#3061ac'
            ],
            [
                'name' => 'color-top-sites-card-header-border',
                'slug' => 'color-top-sites-card-header-border',
                'color' => '#4c96e0'
            ],
            [
                'name' => 'color-top-sites-card-content-table-td-a',
                'slug' => 'color-top-sites-card-content-table-td-a',
                'color' => '#3061ad'
            ],
            [
                'name' => 'color-top-sites-card-content-table-td-a-bg',
                'slug' => 'color-top-sites-card-content-table-td-a-bg',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-top-sites-card-content-table-td-a-border',
                'slug' => 'color-top-sites-card-content-table-td-a-border',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-top-sites-card-content-table-td-a-hover',
                'slug' => 'color-top-sites-card-content-table-td-a-hover',
                'color' => '#222222'
            ],
            [
                'name' => 'color-top-sites-card-content-table-td-a-hover-bg',
                'slug' => 'color-top-sites-card-content-table-td-a-hover-bg',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-top-sites-card-content-table-td-a-hover-border',
                'slug' => 'color-top-sites-card-content-table-td-a-hover-border',
                'color' => '#0160ac'
            ],
            [
                'name' => 'color-top-sites-card-content-table-td-border',
                'slug' => 'color-top-sites-card-content-table-td-border',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-top-sites-card-footer-a',
                'slug' => 'color-top-sites-card-footer-a',
                'color' => '#ffffff'
            ],
            [
                'name' => 'color-top-sites-card-footer-a-bg',
                'slug' => 'color-top-sites-card-footer-a-bg',
                'color' => '#5abd0a'
            ],
            [
                'name' => 'color-top-sites-card-footer-a-border',
                'slug' => 'color-top-sites-card-footer-a-border',
                'color' => '#68f96e'
            ],
            [
                'name' => 'color-top-sites-card-footer-a-hover',
                'slug' => 'color-top-sites-card-footer-a-hover',
                'color' => '#244d0e'
            ],
            [
                'name' => 'color-top-sites-card-footer-a-hover-bg',
                'slug' => 'color-top-sites-card-footer-a-hover-bg',
                'color' => '#5abd0a;'
            ],
            [
                'name' => 'color-top-sites-card-footer-a-hover-border',
                'slug' => 'color-top-sites-card-footer-a-hover-border',
                'color' => '#244d0e'
            ],
        ];
    }

    public function getStylesToloadGeneratePress()
    {
        return [
            [
                'customSelector' => '.rdg-top-sites .card-header h5',
                'fontSize' => '1.125rem',
                'fontSizeTablet' => '.9rem',
                'fontWeight' => '700',
            ],
            [
                'customSelector' => '.rdg-top-sites .card-content table td',
                'fontSize' => '.8rem',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.rdg-top-sites .card-footer a',
                'fontSize' => '.8rem',
                'fontWeight' => '500',
            ],
        ];
    }
}

$rdg_top_sites_class = new Rdg_Blocks_Top_Sites();
$rdg_top_sites_class->init();

return $rdg_top_sites_class;
