<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Quick_Links_Sidebar extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_QUICK_LINKS_SIDEBAR;
    private $block_folder_name = 'rdg-quick-links-sidebar';
    private $block_title = 'RDG Quick Links Sidebar';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'quick', 'link', 'sidebar'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_quick_links_sidebar.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }
}

$rdg_quick_links_sidebar_class = new Rdg_Blocks_Quick_Links_Sidebar();
$rdg_quick_links_sidebar_class->init();

return $rdg_quick_links_sidebar_class;
