<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Rdg_Blocks_Game_Links extends Rdg_Blocks_Base
{
    protected $block_name = BLOCK_RDG_GAME_LINKS;
    private $block_folder_name = BLOCK_RDG_GAME_LINKS;
    private $block_title = 'RDG Game Links';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['rdg', 'custom', 'game', 'link'];
    private $block_mode = 'preview';
    private $block_category = RDGBLOCKS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $rdg_helpers = new Rdg_Blocks_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => RDGBLOCKS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $rdg_helpers->webpack('rdg_game_links.css'),
                'enqueue_assets' => function(){
                    wp_register_script('rdg_game_links', RDGBLOCKS_PLUGIN_URL.'blocks/rdg-game-links/assets/js/rdg-game-links.js', [], '1', true);
                    wp_enqueue_script('rdg_game_links');
                    wp_localize_script('rdg_game_links','rdg_game_links',['ajaxurl' => admin_url('admin-ajax.php')]);
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }
}

$rdg_game_links_class = new Rdg_Blocks_Game_Links();
$rdg_game_links_class->init();

return $rdg_game_links_class;
